/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.api;

import com.google.inject.Inject;
import java.util.function.Consumer;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.testing.clients.OverlordResourceTestClient;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.testng.Assert;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"http-endpoint"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITOverlordResourceNotFoundTest {
    @Inject
    protected OverlordResourceTestClient indexer;

    @Test
    public void testGetSupervisorStatusNotFound() {
        this.callAndCheckNotFound(arg_0 -> ((OverlordResourceTestClient)this.indexer).getSupervisorStatus(arg_0));
    }

    @Test
    public void testGetSupervisorHistoryNotFound() {
        this.callAndCheckNotFound(arg_0 -> ((OverlordResourceTestClient)this.indexer).getSupervisorHistory(arg_0));
    }

    @Test
    public void testResumeSupervisorNotFound() {
        this.callAndCheckNotFound(arg_0 -> ((OverlordResourceTestClient)this.indexer).resumeSupervisor(arg_0));
    }

    @Test
    public void testSuspendSupervisorNotFound() {
        this.callAndCheckNotFound(arg_0 -> ((OverlordResourceTestClient)this.indexer).suspendSupervisor(arg_0));
    }

    @Test
    public void testShutdownSupervisorNotFound() {
        this.callAndCheckNotFound(arg_0 -> ((OverlordResourceTestClient)this.indexer).shutdownSupervisor(arg_0));
    }

    @Test
    public void testTerminateSupervisorNotFound() {
        this.callAndCheckNotFound(arg_0 -> ((OverlordResourceTestClient)this.indexer).terminateSupervisor(arg_0));
    }

    @Test
    public void testGetSupervisorHealthNotFound() {
        this.callAndCheckNotFound(arg_0 -> ((OverlordResourceTestClient)this.indexer).getSupervisorHealth(arg_0));
    }

    @Test
    public void testStatsSupervisorNotFound() {
        this.callAndCheckNotFound(arg_0 -> ((OverlordResourceTestClient)this.indexer).statsSupervisor(arg_0));
    }

    @Test
    public void testResetSupervisorNotFound() {
        this.callAndCheckNotFound(arg_0 -> ((OverlordResourceTestClient)this.indexer).resetSupervisor(arg_0));
    }

    @Test
    public void testGetTaskStatusNotFound() {
        this.callAndCheckNotFound(arg_0 -> ((OverlordResourceTestClient)this.indexer).getTaskStatus(arg_0));
    }

    @Test
    public void testShutdownTaskNotFound() {
        this.callAndCheckNotFound(arg_0 -> ((OverlordResourceTestClient)this.indexer).shutdownTask(arg_0));
    }

    @Test
    public void testGetTaskLogNotFound() {
        this.callAndCheckNotFound(arg_0 -> ((OverlordResourceTestClient)this.indexer).getTaskLog(arg_0));
    }

    @Test
    public void testGetTaskReportNotFound() {
        this.callAndCheckNotFound(arg_0 -> ((OverlordResourceTestClient)this.indexer).getTaskReport(arg_0));
    }

    @Test
    public void testGetTaskPayLoadNotFound() {
        this.callAndCheckNotFound(arg_0 -> ((OverlordResourceTestClient)this.indexer).getTaskPayload(arg_0));
    }

    private void callAndCheckNotFound(Consumer<String> runnable) {
        String supervisorId = "not_exist_id";
        try {
            runnable.accept(supervisorId);
        }
        catch (ISE e) {
            Assert.assertTrue((e.getMessage().contains("[404 Not Found") && e.getMessage().contains(supervisorId) ? 1 : 0) != 0, (String)("Unexpected exception. Message does not match expected. " + e.getMessage()));
            return;
        }
        Assert.fail((String)"Should not go to here");
    }
}

