/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.api;

import com.google.inject.Inject;
import java.io.IOException;
import java.util.List;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.testing.clients.OverlordResourceTestClient;
import org.apache.druid.testing.clients.TaskResponseObject;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.tests.indexer.AbstractIndexerTest;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"http-endpoint"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITOverlordResourceTest {
    private static final String INGESTION_SPEC = "/api/overlord-resource-test-task.json";
    @Inject
    protected OverlordResourceTestClient indexer;

    @Test
    public void testGetAllTasks() throws IOException {
        String taskSpec = AbstractIndexerTest.getResourceAsString(INGESTION_SPEC);
        String taskId = this.indexer.submitTask(taskSpec);
        ITRetryUtil.retryUntil(() -> {
            List tasks = this.indexer.getAllTasks();
            TaskResponseObject taskStatus = tasks.stream().filter(task -> taskId.equals(task.getId())).findAny().orElseThrow(() -> new ISE("Cannot find task[%s]", new Object[]{taskId}));
            TaskState status = taskStatus.getStatus();
            if (status == TaskState.FAILED) {
                throw new ISE("Task[%s] FAILED", new Object[]{taskId});
            }
            return status == TaskState.SUCCESS;
        }, (boolean)true, (long)ITRetryUtil.DEFAULT_RETRY_SLEEP, (int)240, (String)taskId);
    }
}

