/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.coordinator.duty;

import com.google.inject.Inject;
import org.apache.druid.data.input.MaxSizeSplitHintSpec;
import org.apache.druid.data.input.SplitHintSpec;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.java.util.common.granularity.Granularities;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.CoordinatorCompactionConfig;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskGranularityConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskIOConfig;
import org.apache.druid.server.coordinator.UserCompactionTaskQueryTuningConfig;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.clients.CompactionResourceTestClient;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.tests.indexer.AbstractIndexerTest;
import org.joda.time.Period;
import org.testng.Assert;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"upgrade"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITAutoCompactionUpgradeTest
extends AbstractIndexerTest {
    private static final Logger LOG = new Logger(ITAutoCompactionUpgradeTest.class);
    private static final String UPGRADE_DATASOURCE_NAME = "upgradeTest";
    @Inject
    protected CompactionResourceTestClient compactionResource;
    @Inject
    private IntegrationTestingConfig config;

    @Test
    public void testUpgradeAutoCompactionConfigurationWhenConfigurationFromOlderVersionAlreadyExist() throws Exception {
        CoordinatorCompactionConfig coordinatorCompactionConfig = this.compactionResource.getCoordinatorCompactionConfigs();
        DataSourceCompactionConfig foundDataSourceCompactionConfig = null;
        for (DataSourceCompactionConfig dataSourceCompactionConfig : coordinatorCompactionConfig.getCompactionConfigs()) {
            if (!dataSourceCompactionConfig.getDataSource().equals(UPGRADE_DATASOURCE_NAME)) continue;
            foundDataSourceCompactionConfig = dataSourceCompactionConfig;
        }
        Assert.assertNotNull(foundDataSourceCompactionConfig);
        DynamicPartitionsSpec newPartitionsSpec = new DynamicPartitionsSpec(Integer.valueOf(4000), null);
        Period newSkipOffset = Period.seconds((int)0);
        DataSourceCompactionConfig compactionConfig = new DataSourceCompactionConfig(UPGRADE_DATASOURCE_NAME, null, null, null, newSkipOffset, new UserCompactionTaskQueryTuningConfig(null, null, null, null, (SplitHintSpec)new MaxSizeSplitHintSpec(null, Integer.valueOf(1)), (PartitionsSpec)newPartitionsSpec, null, null, null, null, null, Integer.valueOf(1), null, null, null, null, null, Integer.valueOf(1), null), new UserCompactionTaskGranularityConfig(Granularities.YEAR, null, null), null, null, null, new UserCompactionTaskIOConfig(Boolean.valueOf(true)), null);
        this.compactionResource.submitCompactionConfig(compactionConfig);
        Thread.sleep(2000L);
        coordinatorCompactionConfig = this.compactionResource.getCoordinatorCompactionConfigs();
        foundDataSourceCompactionConfig = null;
        for (DataSourceCompactionConfig dataSourceCompactionConfig : coordinatorCompactionConfig.getCompactionConfigs()) {
            if (!dataSourceCompactionConfig.getDataSource().equals(UPGRADE_DATASOURCE_NAME)) continue;
            foundDataSourceCompactionConfig = dataSourceCompactionConfig;
        }
        Assert.assertNotNull((Object)foundDataSourceCompactionConfig);
        Assert.assertNotNull((Object)foundDataSourceCompactionConfig.getTuningConfig());
        Assert.assertEquals((Object)foundDataSourceCompactionConfig.getTuningConfig().getPartitionsSpec(), (Object)newPartitionsSpec);
        Assert.assertEquals((Object)foundDataSourceCompactionConfig.getSkipOffsetFromLatest(), (Object)newSkipOffset);
    }
}

