/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.hadoop;

import java.io.Closeable;
import java.util.UUID;
import java.util.function.Function;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;

public abstract class AbstractGcsInputHadoopIndexTest
extends AbstractITBatchIndexTest {
    private static final String INDEX_TASK = "/hadoop/wikipedia_hadoop_gcs_input_index_task.json";
    private static final String INDEX_QUERIES_RESOURCE = "/indexer/wikipedia_index_queries.json";

    void doTest(Pair<Boolean, Boolean> segmentAvailabilityConfirmationPair) throws Exception {
        String indexDatasource = "wikipedia_hadoop_index_test_" + UUID.randomUUID();
        try (Closeable ignored1 = this.unloader(indexDatasource + this.config.getExtraDatasourceNameSuffix());){
            Function<String, String> gcsPropsTransform = spec -> {
                try {
                    String path = StringUtils.format((String)"gs://%s/%s", (Object[])new Object[]{this.config.getCloudBucket(), this.config.getCloudPath()});
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_PATHS%%", (String)path);
                    spec = StringUtils.replace((String)spec, (String)"%%GCS_KEYFILE_PATH%%", (String)this.config.getHadoopGcsCredentialsPath());
                    return spec;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            this.doIndexTest(indexDatasource, INDEX_TASK, gcsPropsTransform, INDEX_QUERIES_RESOURCE, false, true, true, segmentAvailabilityConfirmationPair);
        }
    }
}

