/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.hadoop;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.io.Closeable;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import org.apache.druid.indexer.partitions.DimensionBasedPartitionsSpec;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.testing.clients.CoordinatorResourceTestClient;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"hdfs-deep-storage"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITHadoopIndexTest
extends AbstractITBatchIndexTest {
    private static final Logger LOG = new Logger(ITHadoopIndexTest.class);
    private static final String BATCH_TASK = "/hadoop/batch_hadoop_indexer.json";
    private static final String BATCH_QUERIES_RESOURCE = "/hadoop/batch_hadoop_queries.json";
    private static final String BATCH_DATASOURCE = "batchLegacyHadoop";
    private static final String INDEX_TASK = "/hadoop/wikipedia_hadoop_index_task.json";
    private static final String INDEX_QUERIES_RESOURCE = "/indexer/wikipedia_index_queries.json";
    private static final String INDEX_DATASOURCE = "wikipedia_hadoop_index_test";
    private static final String REINDEX_TASK = "/hadoop/wikipedia_hadoop_reindex_task.json";
    private static final String REINDEX_QUERIES_RESOURCE = "/indexer/wikipedia_reindex_queries.json";
    private static final String REINDEX_DATASOURCE = "wikipedia_hadoop_reindex_test";
    private static final CoordinatorDynamicConfig DYNAMIC_CONFIG_PAUSED = CoordinatorDynamicConfig.builder().withPauseCoordination(true).build();
    private static final CoordinatorDynamicConfig DYNAMIC_CONFIG_DEFAULT = CoordinatorDynamicConfig.builder().build();
    @Inject
    CoordinatorResourceTestClient coordinatorClient;

    @DataProvider
    public static Object[][] resources() {
        return new Object[][]{{new HashedPartitionsSpec(Integer.valueOf(3), null, null)}, {new HashedPartitionsSpec(null, Integer.valueOf(3), (List)ImmutableList.of((Object)"page"))}, {new HashedPartitionsSpec(null, Integer.valueOf(3), (List)ImmutableList.of((Object)"page", (Object)"user"))}, {new HashedPartitionsSpec(null, Integer.valueOf(3), (List)ImmutableList.of((Object)"page"), HashPartitionFunction.MURMUR3_32_ABS)}, {new SingleDimensionPartitionsSpec(Integer.valueOf(1000), null, null, false)}, {new SingleDimensionPartitionsSpec(Integer.valueOf(1000), null, "page", false)}, {new SingleDimensionPartitionsSpec(Integer.valueOf(1000), null, null, true)}};
    }

    @Test
    public void testLegacyITHadoopIndexTest() throws Exception {
        String indexDatasource = "batchLegacyHadoop_" + UUID.randomUUID();
        try (Closeable ignored0 = this.unloader(indexDatasource + this.config.getExtraDatasourceNameSuffix());){
            Function<String, String> specPathsTransform = spec -> {
                try {
                    String path = "/batch_index/tsv";
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_PATHS%%", (String)path);
                    return spec;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            this.doIndexTest(indexDatasource, BATCH_TASK, specPathsTransform, BATCH_QUERIES_RESOURCE, false, true, true, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
        }
    }

    @Test(dataProvider="resources")
    public void testIndexData(DimensionBasedPartitionsSpec partitionsSpec) throws Exception {
        String indexDatasource = "wikipedia_hadoop_index_test_" + UUID.randomUUID();
        String reindexDatasource = "wikipedia_hadoop_reindex_test_" + UUID.randomUUID();
        try (Closeable ignored1 = this.unloader(indexDatasource + this.config.getExtraDatasourceNameSuffix());
             Closeable ignored2 = this.unloader(reindexDatasource + this.config.getExtraDatasourceNameSuffix());){
            Function<String, String> specPathsTransform = spec -> {
                try {
                    String path = "/batch_index/json";
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_PATHS%%", (String)path);
                    spec = StringUtils.replace((String)spec, (String)"%%PARTITIONS_SPEC%%", (String)this.jsonMapper.writeValueAsString((Object)partitionsSpec));
                    spec = StringUtils.replace((String)spec, (String)"%%SEGMENT_AVAIL_TIMEOUT_MILLIS%%", (String)this.jsonMapper.writeValueAsString((Object)0));
                    return spec;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            this.doIndexTest(indexDatasource, INDEX_TASK, specPathsTransform, INDEX_QUERIES_RESOURCE, false, true, true, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
            this.doReindexTest(indexDatasource, reindexDatasource, REINDEX_TASK, REINDEX_QUERIES_RESOURCE, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
        }
    }

    @Test
    public void testIndexDataAwaitSegmentAvailability() throws Exception {
        String indexDatasource = "wikipedia_hadoop_index_test_" + UUID.randomUUID();
        try (Closeable ignored1 = this.unloader(indexDatasource + this.config.getExtraDatasourceNameSuffix());){
            Function<String, String> specPathsTransform = spec -> {
                try {
                    String path = "/batch_index/json";
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_PATHS%%", (String)path);
                    spec = StringUtils.replace((String)spec, (String)"%%PARTITIONS_SPEC%%", (String)this.jsonMapper.writeValueAsString((Object)new HashedPartitionsSpec(Integer.valueOf(3), null, null)));
                    spec = StringUtils.replace((String)spec, (String)"%%SEGMENT_AVAIL_TIMEOUT_MILLIS%%", (String)this.jsonMapper.writeValueAsString((Object)600000));
                    return spec;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            this.doIndexTest(indexDatasource, INDEX_TASK, specPathsTransform, INDEX_QUERIES_RESOURCE, false, true, true, (Pair<Boolean, Boolean>)new Pair((Object)true, (Object)true));
        }
    }

    @Test
    public void testIndexDataAwaitSegmentAvailabilityFailsButTaskSucceeds() throws Exception {
        String indexDatasource = "wikipedia_hadoop_index_test_" + UUID.randomUUID();
        try (Closeable ignored1 = this.unloader(indexDatasource + this.config.getExtraDatasourceNameSuffix());){
            this.coordinatorClient.postDynamicConfig(DYNAMIC_CONFIG_PAUSED);
            Function<String, String> specPathsTransform = spec -> {
                try {
                    String path = "/batch_index/json";
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_PATHS%%", (String)path);
                    spec = StringUtils.replace((String)spec, (String)"%%PARTITIONS_SPEC%%", (String)this.jsonMapper.writeValueAsString((Object)new HashedPartitionsSpec(Integer.valueOf(3), null, null)));
                    spec = StringUtils.replace((String)spec, (String)"%%SEGMENT_AVAIL_TIMEOUT_MILLIS%%", (String)this.jsonMapper.writeValueAsString((Object)1));
                    return spec;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            this.doIndexTest(indexDatasource, INDEX_TASK, specPathsTransform, INDEX_QUERIES_RESOURCE, false, false, false, (Pair<Boolean, Boolean>)new Pair((Object)true, (Object)false));
            this.coordinatorClient.postDynamicConfig(DYNAMIC_CONFIG_DEFAULT);
            ITRetryUtil.retryUntilTrue(() -> this.coordinatorClient.areSegmentsLoaded(indexDatasource + this.config.getExtraDatasourceNameSuffix()), (String)("Segment Load For: " + indexDatasource + this.config.getExtraDatasourceNameSuffix()));
        }
    }
}

