/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;
import org.testng.annotations.DataProvider;

public abstract class AbstractHdfsInputSourceParallelIndexTest
extends AbstractITBatchIndexTest {
    private static final String INDEX_TASK = "/indexer/wikipedia_cloud_index_task.json";
    private static final String INDEX_QUERIES_RESOURCE = "/indexer/wikipedia_index_queries.json";
    private static final String INPUT_SOURCE_PATHS_KEY = "paths";

    @DataProvider
    public static Object[][] resources() {
        return new Object[][]{{new Pair((Object)INPUT_SOURCE_PATHS_KEY, (Object)"hdfs://druid-it-hadoop:9000/batch_index%%FOLDER_SUFFIX%%")}, {new Pair((Object)INPUT_SOURCE_PATHS_KEY, (Object)ImmutableList.of((Object)"hdfs://druid-it-hadoop:9000/batch_index%%FOLDER_SUFFIX%%"))}, {new Pair((Object)INPUT_SOURCE_PATHS_KEY, (Object)ImmutableList.of((Object)"hdfs://druid-it-hadoop:9000/batch_index%%FOLDER_SUFFIX%%/wikipedia_index_data1%%FILE_EXTENSION%%", (Object)"hdfs://druid-it-hadoop:9000/batch_index%%FOLDER_SUFFIX%%/wikipedia_index_data2%%FILE_EXTENSION%%", (Object)"hdfs://druid-it-hadoop:9000/batch_index%%FOLDER_SUFFIX%%/wikipedia_index_data3%%FILE_EXTENSION%%"))}};
    }

    void doTest(Pair<String, List> hdfsInputSource, AbstractITBatchIndexTest.InputFormatDetails inputFormatDetails, Pair<Boolean, Boolean> segmentAvailabilityConfirmationPair) throws Exception {
        String indexDatasource = "wikipedia_index_test_" + UUID.randomUUID();
        try (Closeable ignored1 = this.unloader(indexDatasource + this.config.getExtraDatasourceNameSuffix());){
            Function<String, String> hdfsPropsTransform = spec -> {
                try {
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_TYPE%%", (String)"hdfs");
                    spec = StringUtils.replace((String)spec, (String)"%%PARTITIONS_SPEC%%", (String)this.jsonMapper.writeValueAsString((Object)new DynamicPartitionsSpec(null, null)));
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_PROPERTY_KEY%%", (String)((String)hdfsInputSource.lhs));
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_FORMAT_TYPE%%", (String)inputFormatDetails.getInputFormatType());
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_PROPERTY_VALUE%%", (String)this.jsonMapper.writeValueAsString(hdfsInputSource.rhs));
                    spec = StringUtils.replace((String)spec, (String)"%%FOLDER_SUFFIX%%", (String)inputFormatDetails.getFolderSuffix());
                    spec = StringUtils.replace((String)spec, (String)"%%FILE_EXTENSION%%", (String)inputFormatDetails.getFileExtension());
                    return spec;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            this.doIndexTest(indexDatasource, INDEX_TASK, hdfsPropsTransform, INDEX_QUERIES_RESOURCE, false, true, true, segmentAvailabilityConfirmationPair);
        }
    }
}

