/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.google.common.collect.FluentIterable;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.druid.indexer.partitions.SecondaryPartitionType;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReport;
import org.apache.druid.indexing.common.IngestionStatsAndErrorsTaskReportData;
import org.apache.druid.indexing.common.TaskReport;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.clients.ClientInfoResourceTestClient;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.testing.utils.SqlTestQueryHelper;
import org.apache.druid.tests.indexer.AbstractIndexerTest;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentTimeline;
import org.apache.druid.timeline.TimelineObjectHolder;
import org.testng.Assert;

public abstract class AbstractITBatchIndexTest
extends AbstractIndexerTest {
    private static final Logger LOG = new Logger(AbstractITBatchIndexTest.class);
    @Inject
    protected IntegrationTestingConfig config;
    @Inject
    protected SqlTestQueryHelper sqlQueryHelper;
    @Inject
    ClientInfoResourceTestClient clientInfoResourceTestClient;

    protected void doIndexTest(String dataSource, String indexTaskFilePath, String queryFilePath, boolean waitForNewVersion, boolean runTestQueries, boolean waitForSegmentsToLoad, Pair<Boolean, Boolean> segmentAvailabilityConfirmationPair) throws IOException {
        this.doIndexTest(dataSource, indexTaskFilePath, Function.identity(), queryFilePath, waitForNewVersion, runTestQueries, waitForSegmentsToLoad, segmentAvailabilityConfirmationPair);
    }

    protected void doIndexTest(String dataSource, String indexTaskFilePath, Function<String, String> taskSpecTransform, String queryFilePath, boolean waitForNewVersion, boolean runTestQueries, boolean waitForSegmentsToLoad, Pair<Boolean, Boolean> segmentAvailabilityConfirmationPair) throws IOException {
        String fullDatasourceName = dataSource + this.config.getExtraDatasourceNameSuffix();
        String taskSpec = taskSpecTransform.apply(StringUtils.replace((String)AbstractITBatchIndexTest.getResourceAsString(indexTaskFilePath), (String)"%%DATASOURCE%%", (String)fullDatasourceName));
        this.submitTaskAndWait(taskSpec, fullDatasourceName, waitForNewVersion, waitForSegmentsToLoad, segmentAvailabilityConfirmationPair);
        if (runTestQueries) {
            this.doTestQuery(dataSource, queryFilePath);
        }
    }

    protected void doTestQuery(String dataSource, String queryFilePath) {
        try {
            String queryResponseTemplate;
            try {
                InputStream is = AbstractITBatchIndexTest.class.getResourceAsStream(queryFilePath);
                queryResponseTemplate = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new ISE((Throwable)e, "could not read query file: %s", new Object[]{queryFilePath});
            }
            queryResponseTemplate = StringUtils.replace((String)queryResponseTemplate, (String)"%%DATASOURCE%%", (String)(dataSource + this.config.getExtraDatasourceNameSuffix()));
            this.queryHelper.testQueriesFromString(queryResponseTemplate);
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error while testing", new Object[0]);
            throw new RuntimeException(e);
        }
    }

    protected void doReindexTest(String baseDataSource, String reindexDataSource, String reindexTaskFilePath, String queryFilePath, Pair<Boolean, Boolean> segmentAvailabilityConfirmationPair) throws IOException {
        this.doReindexTest(baseDataSource, reindexDataSource, Function.identity(), reindexTaskFilePath, queryFilePath, segmentAvailabilityConfirmationPair);
    }

    void doReindexTest(String baseDataSource, String reindexDataSource, Function<String, String> taskSpecTransform, String reindexTaskFilePath, String queryFilePath, Pair<Boolean, Boolean> segmentAvailabilityConfirmationPair) throws IOException {
        String fullBaseDatasourceName = baseDataSource + this.config.getExtraDatasourceNameSuffix();
        String fullReindexDatasourceName = reindexDataSource + this.config.getExtraDatasourceNameSuffix();
        String taskSpec = StringUtils.replace((String)AbstractITBatchIndexTest.getResourceAsString(reindexTaskFilePath), (String)"%%DATASOURCE%%", (String)fullBaseDatasourceName);
        taskSpec = StringUtils.replace((String)taskSpec, (String)"%%REINDEX_DATASOURCE%%", (String)fullReindexDatasourceName);
        taskSpec = taskSpecTransform.apply(taskSpec);
        this.submitTaskAndWait(taskSpec, fullReindexDatasourceName, false, true, segmentAvailabilityConfirmationPair);
        try {
            String queryResponseTemplate;
            try {
                InputStream is = AbstractITBatchIndexTest.class.getResourceAsStream(queryFilePath);
                queryResponseTemplate = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                throw new ISE((Throwable)e, "could not read query file: %s", new Object[]{queryFilePath});
            }
            queryResponseTemplate = StringUtils.replace((String)queryResponseTemplate, (String)"%%DATASOURCE%%", (String)fullReindexDatasourceName);
            this.queryHelper.testQueriesFromString(queryResponseTemplate);
            List dimensions = this.clientInfoResourceTestClient.getDimensions(fullReindexDatasourceName, "2013-08-31T00:00:00.000Z/2013-09-10T00:00:00.000Z");
            Assert.assertFalse((boolean)dimensions.contains("robot"), (String)("dimensions : " + dimensions));
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error while testing", new Object[0]);
            throw new RuntimeException(e);
        }
    }

    void doIndexTestSqlTest(String dataSource, String indexTaskFilePath, String queryFilePath) throws IOException {
        this.doIndexTestSqlTest(dataSource, indexTaskFilePath, queryFilePath, Function.identity());
    }

    void doIndexTestSqlTest(String dataSource, String indexTaskFilePath, String queryFilePath, Function<String, String> taskSpecTransform) throws IOException {
        String fullDatasourceName = dataSource + this.config.getExtraDatasourceNameSuffix();
        String taskSpec = taskSpecTransform.apply(StringUtils.replace((String)AbstractITBatchIndexTest.getResourceAsString(indexTaskFilePath), (String)"%%DATASOURCE%%", (String)fullDatasourceName));
        Pair dummyPair = new Pair((Object)false, (Object)false);
        this.submitTaskAndWait(taskSpec, fullDatasourceName, false, true, (Pair<Boolean, Boolean>)dummyPair);
        try {
            this.sqlQueryHelper.testQueriesFromFile(queryFilePath);
        }
        catch (Exception e) {
            LOG.error((Throwable)e, "Error while testing", new Object[0]);
            throw new RuntimeException(e);
        }
    }

    protected void submitTaskAndWait(String taskSpec, String dataSourceName, boolean waitForNewVersion, boolean waitForSegmentsToLoad, Pair<Boolean, Boolean> segmentAvailabilityConfirmationPair) {
        List oldVersions = waitForNewVersion ? this.coordinator.getAvailableSegments(dataSourceName) : null;
        long startSubTaskCount = -1L;
        boolean assertRunsSubTasks = taskSpec.contains("index_parallel");
        if (assertRunsSubTasks) {
            startSubTaskCount = this.countCompleteSubTasks(dataSourceName, !taskSpec.contains("dynamic"));
        }
        String taskID = this.indexer.submitTask(taskSpec);
        LOG.info("TaskID for loading index task %s", new Object[]{taskID});
        this.indexer.waitUntilTaskCompletes(taskID);
        if (assertRunsSubTasks) {
            boolean perfectRollup = !taskSpec.contains("dynamic");
            long newSubTasks = this.countCompleteSubTasks(dataSourceName, perfectRollup) - startSubTaskCount;
            Assert.assertTrue((newSubTasks > 0L ? 1 : 0) != 0, (String)StringUtils.format((String)"The supervisor task[%s] didn't create any sub tasks. Was it executed in the parallel mode?", (Object[])new Object[]{taskID}));
        }
        if (segmentAvailabilityConfirmationPair.lhs != null && ((Boolean)segmentAvailabilityConfirmationPair.lhs).booleanValue()) {
            TaskReport reportRaw = (TaskReport)this.indexer.getTaskReport(taskID).get("ingestionStatsAndErrors");
            IngestionStatsAndErrorsTaskReport report = (IngestionStatsAndErrorsTaskReport)reportRaw;
            IngestionStatsAndErrorsTaskReportData reportData = (IngestionStatsAndErrorsTaskReportData)report.getPayload();
            Assert.assertTrue((reportData.getSegmentAvailabilityWaitTimeMs() > 0L ? 1 : 0) != 0);
            if (segmentAvailabilityConfirmationPair.rhs != null) {
                Assert.assertEquals((Object)reportData.isSegmentAvailabilityConfirmed(), (Object)segmentAvailabilityConfirmationPair.rhs);
            }
        }
        if (waitForNewVersion) {
            ITRetryUtil.retryUntilTrue(() -> {
                SegmentTimeline timeline = SegmentTimeline.forSegments((Iterable)this.coordinator.getAvailableSegments(dataSourceName));
                List holders = timeline.lookup(Intervals.ETERNITY);
                return FluentIterable.from((Iterable)holders).transformAndConcat(TimelineObjectHolder::getObject).anyMatch(chunk -> FluentIterable.from((Iterable)oldVersions).anyMatch(oldSegment -> ((DataSegment)chunk.getObject()).overshadows(oldSegment)));
            }, (String)"See a new version");
        }
        if (waitForSegmentsToLoad) {
            ITRetryUtil.retryUntilTrue(() -> this.coordinator.areSegmentsLoaded(dataSourceName), (String)"Segment Load");
        }
    }

    private long countCompleteSubTasks(String dataSource, boolean perfectRollup) {
        return this.indexer.getCompleteTasksForDataSource(dataSource).stream().filter(t -> {
            if (!perfectRollup) {
                return t.getType().equals("single_phase_sub_task");
            }
            return t.getType().equalsIgnoreCase("partial_index_generate") || t.getType().equalsIgnoreCase("partial_dimension_distribution") || t.getType().equalsIgnoreCase("partial_dimension_cardinality") || t.getType().equalsIgnoreCase("partial_range_index_generate") || t.getType().equalsIgnoreCase("partial_index_generic_merge");
        }).count();
    }

    void verifySegmentsCountAndLoaded(String dataSource, int numExpectedSegments) {
        ITRetryUtil.retryUntilTrue(() -> this.coordinator.areSegmentsLoaded(dataSource + this.config.getExtraDatasourceNameSuffix()), (String)"Segment load check");
        ITRetryUtil.retryUntilTrue(() -> {
            List segments = this.coordinator.getAvailableSegments(dataSource + this.config.getExtraDatasourceNameSuffix());
            int segmentCount = segments.size();
            LOG.info("Current segment count: %d, expected: %d", new Object[]{segmentCount, numExpectedSegments});
            return segmentCount == numExpectedSegments;
        }, (String)"Segment count check");
    }

    void verifySegmentsCountAndLoaded(String dataSource, int numExpectedSegments, int numExpectedTombstones) {
        ITRetryUtil.retryUntilTrue(() -> this.coordinator.areSegmentsLoaded(dataSource + this.config.getExtraDatasourceNameSuffix()), (String)"Segment load check");
        ITRetryUtil.retryUntilTrue(() -> {
            List segments = this.coordinator.getAvailableSegments(dataSource + this.config.getExtraDatasourceNameSuffix());
            int segmentCount = segments.size();
            LOG.info("Current segment count: %d, expected: %d", new Object[]{segmentCount, numExpectedSegments});
            int tombstoneCount = 0;
            for (DataSegment segment : segments) {
                if (!segment.isTombstone()) continue;
                ++tombstoneCount;
            }
            LOG.info("Current tombstone count: %d, expected: %d", new Object[]{tombstoneCount, numExpectedTombstones});
            return segmentCount == numExpectedSegments && tombstoneCount == numExpectedTombstones;
        }, (String)"Segment count check");
    }

    void compactData(String dataSource, String compactionTask) throws Exception {
        String fullDatasourceName = dataSource + this.config.getExtraDatasourceNameSuffix();
        List intervalsBeforeCompaction = this.coordinator.getSegmentIntervals(fullDatasourceName);
        intervalsBeforeCompaction.sort(null);
        String template = AbstractITBatchIndexTest.getResourceAsString(compactionTask);
        String taskSpec = StringUtils.replace((String)template, (String)"%%DATASOURCE%%", (String)fullDatasourceName);
        String taskID = this.indexer.submitTask(taskSpec);
        LOG.info("TaskID for compaction task %s", new Object[]{taskID});
        this.indexer.waitUntilTaskCompletes(taskID);
        ITRetryUtil.retryUntilTrue(() -> this.coordinator.areSegmentsLoaded(fullDatasourceName), (String)"Segment Compaction");
        ITRetryUtil.retryUntilTrue(() -> {
            List actualIntervals = this.coordinator.getSegmentIntervals(dataSource + this.config.getExtraDatasourceNameSuffix());
            actualIntervals.sort(null);
            return actualIntervals.equals(intervalsBeforeCompaction);
        }, (String)"Compaction interval check");
    }

    void verifySegmentsCompacted(String dataSource, int expectedCompactedSegmentCount) {
        List segments = this.coordinator.getFullSegmentsMetadata(dataSource + this.config.getExtraDatasourceNameSuffix());
        ArrayList<DataSegment> foundCompactedSegments = new ArrayList<DataSegment>();
        for (DataSegment segment : segments) {
            if (segment.getLastCompactionState() == null) continue;
            foundCompactedSegments.add(segment);
        }
        Assert.assertEquals((int)foundCompactedSegments.size(), (int)expectedCompactedSegmentCount);
        for (DataSegment compactedSegment : foundCompactedSegments) {
            Assert.assertNotNull((Object)compactedSegment.getLastCompactionState());
            Assert.assertNotNull((Object)compactedSegment.getLastCompactionState().getPartitionsSpec());
            Assert.assertEquals((Object)compactedSegment.getLastCompactionState().getPartitionsSpec().getType(), (Object)SecondaryPartitionType.LINEAR);
        }
    }

    public static enum InputFormatDetails {
        AVRO("avro_ocf", ".avro", "/avro"),
        CSV("csv", ".csv", "/csv"),
        TSV("tsv", ".tsv", "/tsv"),
        ORC("orc", ".orc", "/orc"),
        JSON("json", ".json", "/json"),
        PARQUET("parquet", ".parquet", "/parquet");

        private final String inputFormatType;
        private final String fileExtension;
        private final String folderSuffix;

        private InputFormatDetails(String inputFormatType, String fileExtension, String folderSuffix) {
            this.inputFormatType = inputFormatType;
            this.fileExtension = fileExtension;
            this.folderSuffix = folderSuffix;
        }

        public String getInputFormatType() {
            return this.inputFormatType;
        }

        public String getFileExtension() {
            return this.fileExtension;
        }

        public String getFolderSuffix() {
            return this.folderSuffix;
        }
    }
}

