/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;

public abstract class AbstractLocalInputSourceParallelIndexTest
extends AbstractITBatchIndexTest {
    private static final String INDEX_TASK = "/indexer/wikipedia_local_input_source_index_task.json";
    private static final String INDEX_QUERIES_RESOURCE = "/indexer/wikipedia_index_queries.json";

    public void doIndexTest(AbstractITBatchIndexTest.InputFormatDetails inputFormatDetails, Pair<Boolean, Boolean> segmentAvailabilityConfirmationPair) throws Exception {
        this.doIndexTest(inputFormatDetails, (Map<String, Object>)ImmutableMap.of(), segmentAvailabilityConfirmationPair);
    }

    public void doIndexTest(AbstractITBatchIndexTest.InputFormatDetails inputFormatDetails, @Nonnull Map<String, Object> extraInputFormatMap, Pair<Boolean, Boolean> segmentAvailabilityConfirmationPair) throws Exception {
        String indexDatasource = "wikipedia_index_test_" + UUID.randomUUID();
        ImmutableMap inputFormatMap = new ImmutableMap.Builder().putAll(extraInputFormatMap).put((Object)"type", (Object)inputFormatDetails.getInputFormatType()).build();
        try (Closeable ignored1 = this.unloader(indexDatasource + this.config.getExtraDatasourceNameSuffix());){
            Function<String, String> sqlInputSourcePropsTransform = arg_0 -> this.lambda$doIndexTest$0(inputFormatDetails, (Map)inputFormatMap, arg_0);
            this.doIndexTest(indexDatasource, INDEX_TASK, sqlInputSourcePropsTransform, INDEX_QUERIES_RESOURCE, false, true, true, segmentAvailabilityConfirmationPair);
        }
    }

    private /* synthetic */ String lambda$doIndexTest$0(AbstractITBatchIndexTest.InputFormatDetails inputFormatDetails, Map inputFormatMap, String spec) {
        try {
            spec = StringUtils.replace((String)spec, (String)"%%PARTITIONS_SPEC%%", (String)this.jsonMapper.writeValueAsString((Object)new DynamicPartitionsSpec(null, null)));
            spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_FILTER%%", (String)("*" + inputFormatDetails.getFileExtension()));
            spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_BASE_DIR%%", (String)("/resources/data/batch_index" + inputFormatDetails.getFolderSuffix()));
            spec = StringUtils.replace((String)spec, (String)"%%INPUT_FORMAT%%", (String)this.jsonMapper.writeValueAsString((Object)inputFormatMap));
            spec = StringUtils.replace((String)spec, (String)"%%APPEND_TO_EXISTING%%", (String)this.jsonMapper.writeValueAsString((Object)false));
            spec = StringUtils.replace((String)spec, (String)"%%DROP_EXISTING%%", (String)this.jsonMapper.writeValueAsString((Object)false));
            spec = StringUtils.replace((String)spec, (String)"%%FORCE_GUARANTEED_ROLLUP%%", (String)this.jsonMapper.writeValueAsString((Object)false));
            return spec;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

