/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Closeable;
import java.util.function.Function;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"batch-index", "quickstart-compatible"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITCombiningFirehoseFactoryIndexTest
extends AbstractITBatchIndexTest {
    private static final String INDEX_TASK = "/indexer/wikipedia_index_task.json";
    private static final String INDEX_QUERIES_RESOURCE = "/indexer/wikipedia_index_queries.json";
    private static final String INDEX_DATASOURCE = "wikipedia_index_test";
    private static final String COMBINING_INDEX_TASK = "/indexer/wikipedia_combining_firehose_index_task.json";
    private static final String COMBINING_QUERIES_RESOURCE = "/indexer/wikipedia_combining_firehose_index_queries.json";
    private static final String COMBINING_INDEX_DATASOURCE = "wikipedia_comb_index_test";

    @Test
    public void testIndexData() throws Exception {
        try (Closeable ignored1 = this.unloader(INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix());
             Closeable ignored2 = this.unloader(COMBINING_INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix());){
            Function<String, String> combiningFirehoseSpecTransform = spec -> {
                try {
                    return StringUtils.replace((String)spec, (String)"%%COMBINING_DATASOURCE%%", (String)(INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix()));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            Function<String, String> transform = spec -> {
                try {
                    return StringUtils.replace((String)spec, (String)"%%SEGMENT_AVAIL_TIMEOUT_MILLIS%%", (String)this.jsonMapper.writeValueAsString((Object)"0"));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            };
            this.doIndexTest(INDEX_DATASOURCE, INDEX_TASK, transform, INDEX_QUERIES_RESOURCE, false, true, true, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
            this.doIndexTest(COMBINING_INDEX_DATASOURCE, COMBINING_INDEX_TASK, combiningFirehoseSpecTransform, COMBINING_QUERIES_RESOURCE, false, true, true, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
        }
    }
}

