/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.Map;
import java.util.function.Function;
import org.apache.druid.indexer.partitions.DynamicPartitionsSpec;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"batch-index", "quickstart-compatible"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITCombiningInputSourceParallelIndexTest
extends AbstractITBatchIndexTest {
    private static final String INDEX_TASK = "/indexer/wikipedia_local_input_source_index_task.json";
    private static final String INDEX_QUERIES_RESOURCE = "/indexer/wikipedia_index_queries.json";
    private static final String INDEX_DATASOURCE = "wikipedia_index_test";
    private static final String COMBINING_INDEX_TASK = "/indexer/wikipedia_combining_input_source_index_parallel_task.json";
    private static final String COMBINING_QUERIES_RESOURCE = "/indexer/wikipedia_combining_firehose_index_queries.json";
    private static final String COMBINING_INDEX_DATASOURCE = "wikipedia_comb_index_test";

    @Test
    public void testIndexData() throws Exception {
        ImmutableMap inputFormatMap = new ImmutableMap.Builder().put((Object)"type", (Object)"json").build();
        try (Closeable ignored1 = this.unloader(INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix());
             Closeable ignored2 = this.unloader(COMBINING_INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix());){
            Function<String, String> combiningInputSourceSpecTransform = arg_0 -> this.lambda$testIndexData$0((Map)inputFormatMap, arg_0);
            this.doIndexTest(INDEX_DATASOURCE, INDEX_TASK, combiningInputSourceSpecTransform, INDEX_QUERIES_RESOURCE, false, true, true, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
            this.doIndexTest(COMBINING_INDEX_DATASOURCE, COMBINING_INDEX_TASK, combiningInputSourceSpecTransform, COMBINING_QUERIES_RESOURCE, false, true, true, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
        }
    }

    private /* synthetic */ String lambda$testIndexData$0(Map inputFormatMap, String spec) {
        try {
            spec = StringUtils.replace((String)spec, (String)"%%PARTITIONS_SPEC%%", (String)this.jsonMapper.writeValueAsString((Object)new DynamicPartitionsSpec(null, null)));
            spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_FILTER%%", (String)"wikipedia_index_data*");
            spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_BASE_DIR%%", (String)"/resources/data/batch_index/json");
            spec = StringUtils.replace((String)spec, (String)"%%INPUT_FORMAT%%", (String)this.jsonMapper.writeValueAsString((Object)inputFormatMap));
            spec = StringUtils.replace((String)spec, (String)"%%APPEND_TO_EXISTING%%", (String)this.jsonMapper.writeValueAsString((Object)false));
            spec = StringUtils.replace((String)spec, (String)"%%DROP_EXISTING%%", (String)this.jsonMapper.writeValueAsString((Object)false));
            spec = StringUtils.replace((String)spec, (String)"%%FORCE_GUARANTEED_ROLLUP%%", (String)this.jsonMapper.writeValueAsString((Object)false));
            spec = StringUtils.replace((String)spec, (String)"%%COMBINING_DATASOURCE%%", (String)(INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix()));
            return spec;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

