/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;
import org.apache.druid.tests.indexer.AbstractIndexerTest;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"compaction", "quickstart-compatible"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITCompactionSparseColumnTest
extends AbstractIndexerTest {
    private static final String INDEX_DATASOURCE = "sparse_column_index_test";
    private static final String INDEX_TASK = "/indexer/sparse_column_index_task.json";
    private static final String COMPACTION_QUERIES_RESOURCE = "/indexer/sparse_column_index_queries.json";
    private static final String COMPACTION_TASK_WITHOUT_DIMENSION = "/indexer/sparse_column_without_dim_compaction_task.json";
    private static final String COMPACTION_TASK_WITH_DIMENSION = "/indexer/sparse_column_with_dim_compaction_task.json";
    @Inject
    private IntegrationTestingConfig config;
    private String fullDatasourceName;

    @BeforeMethod
    public void setFullDatasourceName(Method method) {
        this.fullDatasourceName = INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix() + "-" + method.getName();
    }

    @Test
    public void testCompactionPerfectRollUpWithoutDimensionSpec() throws Exception {
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            this.loadAndVerifyDataWithSparseColumn(this.fullDatasourceName);
            String template = ITCompactionSparseColumnTest.getResourceAsString(COMPACTION_TASK_WITHOUT_DIMENSION);
            template = StringUtils.replace((String)template, (String)"%%DATASOURCE%%", (String)this.fullDatasourceName);
            String taskID = this.indexer.submitTask(template);
            this.indexer.waitUntilTaskCompletes(taskID);
            ITRetryUtil.retryUntilTrue(() -> this.coordinator.areSegmentsLoaded(this.fullDatasourceName), (String)"Segment Compaction");
            ImmutableList segmentRows = ImmutableList.of(Arrays.asList(1442016000000L, "F", "C", null, null, null, null, 1, 1), Arrays.asList(1442016000000L, "J", "C", null, null, null, null, 1, 1), Arrays.asList(1442016000000L, "R", "J", null, null, null, null, 1, 1), Arrays.asList(1442016000000L, "S", "Z", null, null, null, null, 1, 1), Arrays.asList(1442016000000L, "T", "H", null, null, null, null, 1, 1), Arrays.asList(1442016000000L, "X", null, "A", null, null, null, 1, 1), Arrays.asList(1442016000000L, "X", "H", null, null, null, null, 3, 3), Arrays.asList(1442016000000L, "Z", "H", null, null, null, null, 1, 1));
            this.verifyCompactedData((List<List<Object>>)segmentRows);
        }
    }

    @Test
    public void testCompactionPerfectRollUpWithLexicographicDimensionSpec() throws Exception {
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            this.loadAndVerifyDataWithSparseColumn(this.fullDatasourceName);
            String template = ITCompactionSparseColumnTest.getResourceAsString(COMPACTION_TASK_WITH_DIMENSION);
            template = StringUtils.replace((String)template, (String)"%%DATASOURCE%%", (String)this.fullDatasourceName);
            ImmutableList dimensionsOrder = ImmutableList.of((Object)"dimA", (Object)"dimB", (Object)"dimC");
            template = StringUtils.replace((String)template, (String)"%%DIMENSION_NAMES%%", (String)this.jsonMapper.writeValueAsString((Object)dimensionsOrder));
            String taskID = this.indexer.submitTask(template);
            this.indexer.waitUntilTaskCompletes(taskID);
            ITRetryUtil.retryUntilTrue(() -> this.coordinator.areSegmentsLoaded(this.fullDatasourceName), (String)"Segment Compaction");
            ImmutableList segmentRows = ImmutableList.of(Arrays.asList(1442016000000L, null, "X", "A", 1, 1), Arrays.asList(1442016000000L, "C", "F", null, 1, 1), Arrays.asList(1442016000000L, "C", "J", null, 1, 1), Arrays.asList(1442016000000L, "H", "T", null, 1, 1), Arrays.asList(1442016000000L, "H", "X", null, 3, 3), Arrays.asList(1442016000000L, "H", "Z", null, 1, 1), Arrays.asList(1442016000000L, "J", "R", null, 1, 1), Arrays.asList(1442016000000L, "Z", "S", null, 1, 1));
            this.verifyCompactedData((List<List<Object>>)segmentRows);
        }
    }

    @Test
    public void testCompactionPerfectRollUpWithNonLexicographicDimensionSpec() throws Exception {
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            this.loadAndVerifyDataWithSparseColumn(this.fullDatasourceName);
            String template = ITCompactionSparseColumnTest.getResourceAsString(COMPACTION_TASK_WITH_DIMENSION);
            template = StringUtils.replace((String)template, (String)"%%DATASOURCE%%", (String)this.fullDatasourceName);
            ImmutableList dimensionsOrder = ImmutableList.of((Object)"dimC", (Object)"dimB", (Object)"dimA");
            template = StringUtils.replace((String)template, (String)"%%DIMENSION_NAMES%%", (String)this.jsonMapper.writeValueAsString((Object)dimensionsOrder));
            String taskID = this.indexer.submitTask(template);
            this.indexer.waitUntilTaskCompletes(taskID);
            ITRetryUtil.retryUntilTrue(() -> this.coordinator.areSegmentsLoaded(this.fullDatasourceName), (String)"Segment Compaction");
            ImmutableList segment1Rows = ImmutableList.of(Arrays.asList(1442016000000L, null, "F", "C", 1, 1), Arrays.asList(1442016000000L, null, "J", "C", 1, 1), Arrays.asList(1442016000000L, null, "R", "J", 1, 1), Arrays.asList(1442016000000L, null, "S", "Z", 1, 1), Arrays.asList(1442016000000L, null, "T", "H", 1, 1), Arrays.asList(1442016000000L, null, "X", "H", 3, 3), Arrays.asList(1442016000000L, null, "Z", "H", 1, 1), Arrays.asList(1442016000000L, "A", "X", null, 1, 1));
            this.verifyCompactedData((List<List<Object>>)segment1Rows);
        }
    }

    private void loadAndVerifyDataWithSparseColumn(String fullDatasourceName) throws Exception {
        this.loadData(INDEX_TASK, fullDatasourceName);
        ArrayList<Map<String, List<List<Object>>>> expectedResultBeforeCompaction = new ArrayList<Map<String, List<List<Object>>>>();
        ImmutableList segment1Rows = ImmutableList.of(Arrays.asList(1442016000000L, "F", "C", null, null, null, null, 1, 1), Arrays.asList(1442016000000L, "J", "C", null, null, null, null, 1, 1), Arrays.asList(1442016000000L, "X", "H", null, null, null, null, 1, 1));
        expectedResultBeforeCompaction.add((Map<String, List<List<Object>>>)ImmutableMap.of((Object)"events", (Object)segment1Rows));
        ImmutableList segment2Rows = ImmutableList.of(Arrays.asList(1442016000000L, "S", "Z", null, null, null, null, 1, 1), Arrays.asList(1442016000000L, "X", "H", null, null, null, null, 1, 1), Arrays.asList(1442016000000L, "Z", "H", null, null, null, null, 1, 1));
        expectedResultBeforeCompaction.add((Map<String, List<List<Object>>>)ImmutableMap.of((Object)"events", (Object)segment2Rows));
        ImmutableList segment3Rows = ImmutableList.of(Arrays.asList(1442016000000L, "R", "J", null, null, null, null, 1, 1), Arrays.asList(1442016000000L, "T", "H", null, null, null, null, 1, 1), Arrays.asList(1442016000000L, "X", "H", null, null, null, null, 1, 1));
        expectedResultBeforeCompaction.add((Map<String, List<List<Object>>>)ImmutableMap.of((Object)"events", (Object)segment3Rows));
        ImmutableList segment4Rows = ImmutableList.of(Arrays.asList(1442016000000L, "X", null, "A", null, null, null, 1, 1));
        expectedResultBeforeCompaction.add((Map<String, List<List<Object>>>)ImmutableMap.of((Object)"events", (Object)segment4Rows));
        this.verifyQueryResult(expectedResultBeforeCompaction, 10, 10, 1.0);
    }

    private void verifyCompactedData(List<List<Object>> segmentRows) throws Exception {
        ArrayList<Map<String, List<List<Object>>>> expectedResultAfterCompaction = new ArrayList<Map<String, List<List<Object>>>>();
        expectedResultAfterCompaction.add((Map<String, List<List<Object>>>)ImmutableMap.of((Object)"events", segmentRows));
        this.verifyQueryResult(expectedResultAfterCompaction, 8, 10, 0.8);
    }

    private void verifyQueryResult(List<Map<String, List<List<Object>>>> expectedScanResult, int expectedNumRoll, int expectedSumCount, double expectedRollupRatio) throws Exception {
        InputStream is = AbstractITBatchIndexTest.class.getResourceAsStream(COMPACTION_QUERIES_RESOURCE);
        String queryResponseTemplate = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        queryResponseTemplate = StringUtils.replace((String)queryResponseTemplate, (String)"%%DATASOURCE%%", (String)this.fullDatasourceName);
        queryResponseTemplate = StringUtils.replace((String)queryResponseTemplate, (String)"%%EXPECTED_SCAN_RESULT%%", (String)this.jsonMapper.writeValueAsString(expectedScanResult));
        queryResponseTemplate = StringUtils.replace((String)queryResponseTemplate, (String)"%%EXPECTED_SUM_COUNT%%", (String)this.jsonMapper.writeValueAsString((Object)expectedSumCount));
        queryResponseTemplate = StringUtils.replace((String)queryResponseTemplate, (String)"%%EXPECTED_ROLLUP_RATIO%%", (String)this.jsonMapper.writeValueAsString((Object)expectedRollupRatio));
        queryResponseTemplate = StringUtils.replace((String)queryResponseTemplate, (String)"%%EXPECTED_NUM_ROW%%", (String)this.jsonMapper.writeValueAsString((Object)expectedNumRoll));
        this.queryHelper.testQueriesFromString(queryResponseTemplate);
    }
}

