/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.google.inject.Inject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;
import org.apache.druid.tests.indexer.AbstractIndexerTest;
import org.joda.time.Chronology;
import org.joda.time.Interval;
import org.joda.time.chrono.ISOChronology;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"compaction", "quickstart-compatible"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITCompactionTaskTest
extends AbstractIndexerTest {
    private static final Logger LOG = new Logger(ITCompactionTaskTest.class);
    private static final String INDEX_TASK = "/indexer/wikipedia_index_task.json";
    private static final String INDEX_QUERIES_RESOURCE = "/indexer/wikipedia_index_queries.json";
    private static final String INDEX_QUERIES_YEAR_RESOURCE = "/indexer/wikipedia_index_queries_year_query_granularity.json";
    private static final String INDEX_QUERIES_HOUR_RESOURCE = "/indexer/wikipedia_index_queries_hour_query_granularity.json";
    private static final String INDEX_DATASOURCE = "wikipedia_index_test";
    private static final String SEGMENT_METADATA_QUERY_RESOURCE = "/indexer/segment_metadata_query.json";
    private static final String COMPACTION_TASK = "/indexer/wikipedia_compaction_task.json";
    private static final String COMPACTION_TASK_WITH_SEGMENT_GRANULARITY = "/indexer/wikipedia_compaction_task_with_segment_granularity.json";
    private static final String COMPACTION_TASK_WITH_GRANULARITY_SPEC = "/indexer/wikipedia_compaction_task_with_granularity_spec.json";
    private static final String INDEX_TASK_WITH_TIMESTAMP = "/indexer/wikipedia_with_timestamp_index_task.json";
    @Inject
    private IntegrationTestingConfig config;
    private String fullDatasourceName;

    @BeforeMethod
    public void setFullDatasourceName(Method method) {
        this.fullDatasourceName = INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix() + "-" + method.getName();
    }

    @Test
    public void testCompaction() throws Exception {
        this.loadDataAndCompact(INDEX_TASK, INDEX_QUERIES_RESOURCE, COMPACTION_TASK, null);
    }

    @Test
    public void testCompactionWithSegmentGranularity() throws Exception {
        this.loadDataAndCompact(INDEX_TASK, INDEX_QUERIES_RESOURCE, COMPACTION_TASK_WITH_SEGMENT_GRANULARITY, GranularityType.MONTH);
    }

    @Test
    public void testCompactionWithSegmentGranularityInGranularitySpec() throws Exception {
        this.loadDataAndCompact(INDEX_TASK, INDEX_QUERIES_RESOURCE, COMPACTION_TASK_WITH_GRANULARITY_SPEC, GranularityType.MONTH);
    }

    @Test
    public void testCompactionWithQueryGranularityInGranularitySpec() throws Exception {
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            this.loadData(INDEX_TASK, this.fullDatasourceName);
            this.checkNumberOfSegments(4);
            List expectedIntervalAfterCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            expectedIntervalAfterCompaction.sort(null);
            this.checkQueryGranularity(SEGMENT_METADATA_QUERY_RESOURCE, GranularityType.SECOND.name(), 4);
            String queryResponseTemplate = this.getQueryResponseTemplate(INDEX_QUERIES_RESOURCE);
            this.queryHelper.testQueriesFromString(queryResponseTemplate);
            this.compactData(COMPACTION_TASK_WITH_GRANULARITY_SPEC, null, GranularityType.HOUR);
            this.checkNumberOfSegments(2);
            queryResponseTemplate = this.getQueryResponseTemplate(INDEX_QUERIES_HOUR_RESOURCE);
            this.queryHelper.testQueriesFromString(queryResponseTemplate);
            this.checkQueryGranularity(SEGMENT_METADATA_QUERY_RESOURCE, GranularityType.HOUR.name(), 2);
            this.checkCompactionIntervals(expectedIntervalAfterCompaction);
            this.compactData(COMPACTION_TASK_WITH_GRANULARITY_SPEC, null, GranularityType.MINUTE);
            this.checkNumberOfSegments(2);
            queryResponseTemplate = this.getQueryResponseTemplate(INDEX_QUERIES_HOUR_RESOURCE);
            this.queryHelper.testQueriesFromString(queryResponseTemplate);
            this.checkQueryGranularity(SEGMENT_METADATA_QUERY_RESOURCE, GranularityType.MINUTE.name(), 2);
            this.checkCompactionIntervals(expectedIntervalAfterCompaction);
        }
    }

    @Test
    public void testCompactionWithSegmentGranularityAndQueryGranularityInGranularitySpec() throws Exception {
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            this.loadData(INDEX_TASK, this.fullDatasourceName);
            this.checkNumberOfSegments(4);
            ArrayList<String> expectedIntervalAfterCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            expectedIntervalAfterCompaction.sort(null);
            this.checkQueryGranularity(SEGMENT_METADATA_QUERY_RESOURCE, GranularityType.SECOND.name(), 4);
            String queryResponseTemplate = this.getQueryResponseTemplate(INDEX_QUERIES_RESOURCE);
            this.queryHelper.testQueriesFromString(queryResponseTemplate);
            this.compactData(COMPACTION_TASK_WITH_GRANULARITY_SPEC, GranularityType.YEAR, GranularityType.YEAR);
            this.checkNumberOfSegments(1);
            queryResponseTemplate = this.getQueryResponseTemplate(INDEX_QUERIES_YEAR_RESOURCE);
            this.queryHelper.testQueriesFromString(queryResponseTemplate);
            this.checkQueryGranularity(SEGMENT_METADATA_QUERY_RESOURCE, GranularityType.YEAR.name(), 1);
            ArrayList<String> newIntervals = new ArrayList<String>();
            for (String interval : expectedIntervalAfterCompaction) {
                for (Interval newinterval : GranularityType.YEAR.getDefaultGranularity().getIterable(new Interval((Object)interval, (Chronology)ISOChronology.getInstanceUTC()))) {
                    newIntervals.add(newinterval.toString());
                }
            }
            expectedIntervalAfterCompaction = newIntervals;
            this.checkCompactionIntervals(expectedIntervalAfterCompaction);
        }
    }

    @Test
    public void testCompactionWithTimestampDimension() throws Exception {
        this.loadDataAndCompact(INDEX_TASK_WITH_TIMESTAMP, INDEX_QUERIES_RESOURCE, COMPACTION_TASK, null);
    }

    private void loadDataAndCompact(String indexTask, String queriesResource, String compactionResource, GranularityType newSegmentGranularity) throws Exception {
        try (Closeable ignored = this.unloader(this.fullDatasourceName);){
            this.loadData(indexTask, this.fullDatasourceName);
            this.checkNumberOfSegments(4);
            ArrayList<String> expectedIntervalAfterCompaction = this.coordinator.getSegmentIntervals(this.fullDatasourceName);
            expectedIntervalAfterCompaction.sort(null);
            this.checkQueryGranularity(SEGMENT_METADATA_QUERY_RESOURCE, GranularityType.SECOND.name(), 4);
            String queryResponseTemplate = this.getQueryResponseTemplate(queriesResource);
            queryResponseTemplate = StringUtils.replace((String)queryResponseTemplate, (String)"%%SEGMENT_AVAIL_TIMEOUT_MILLIS%%", (String)this.jsonMapper.writeValueAsString((Object)"0"));
            this.queryHelper.testQueriesFromString(queryResponseTemplate);
            this.compactData(compactionResource, newSegmentGranularity, null);
            this.checkNumberOfSegments(2);
            this.queryHelper.testQueriesFromString(queryResponseTemplate);
            this.checkQueryGranularity(SEGMENT_METADATA_QUERY_RESOURCE, GranularityType.SECOND.name(), 2);
            if (newSegmentGranularity != null) {
                ArrayList<String> newIntervals = new ArrayList<String>();
                for (String interval : expectedIntervalAfterCompaction) {
                    for (Interval newinterval : newSegmentGranularity.getDefaultGranularity().getIterable(new Interval((Object)interval, (Chronology)ISOChronology.getInstanceUTC()))) {
                        newIntervals.add(newinterval.toString());
                    }
                }
                expectedIntervalAfterCompaction = newIntervals;
            }
            this.checkCompactionIntervals((List<String>)expectedIntervalAfterCompaction);
        }
    }

    private void compactData(String compactionResource, GranularityType newSegmentGranularity, GranularityType newQueryGranularity) throws Exception {
        String template = ITCompactionTaskTest.getResourceAsString(compactionResource);
        template = StringUtils.replace((String)template, (String)"%%DATASOURCE%%", (String)this.fullDatasourceName);
        HashMap<String, String> granularityMap = new HashMap<String, String>();
        if (newSegmentGranularity != null) {
            granularityMap.put("segmentGranularity", newSegmentGranularity.name());
        }
        if (newQueryGranularity != null) {
            granularityMap.put("queryGranularity", newQueryGranularity.name());
        }
        template = StringUtils.replace((String)template, (String)"%%GRANULARITY_SPEC%%", (String)this.jsonMapper.writeValueAsString(granularityMap));
        if (newSegmentGranularity != null) {
            template = StringUtils.replace((String)template, (String)"%%SEGMENT_GRANULARITY%%", (String)newSegmentGranularity.name());
        }
        String taskID = this.indexer.submitTask(template);
        LOG.info("TaskID for compaction task %s", new Object[]{taskID});
        this.indexer.waitUntilTaskCompletes(taskID);
        ITRetryUtil.retryUntilTrue(() -> this.coordinator.areSegmentsLoaded(this.fullDatasourceName), (String)"Segment Compaction");
    }

    private void checkQueryGranularity(String queryResource, String expectedQueryGranularity, int segmentCount) throws Exception {
        String queryResponseTemplate;
        try {
            InputStream is = AbstractITBatchIndexTest.class.getResourceAsStream(queryResource);
            queryResponseTemplate = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "could not read query file: %s", new Object[]{queryResource});
        }
        queryResponseTemplate = StringUtils.replace((String)queryResponseTemplate, (String)"%%DATASOURCE%%", (String)this.fullDatasourceName);
        queryResponseTemplate = StringUtils.replace((String)queryResponseTemplate, (String)"%%ANALYSIS_TYPE%%", (String)"queryGranularity");
        queryResponseTemplate = StringUtils.replace((String)queryResponseTemplate, (String)"%%INTERVALS%%", (String)"2013-08-31/2013-09-02");
        ArrayList expectedResults = new ArrayList();
        for (int i = 0; i < segmentCount; ++i) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("queryGranularity", expectedQueryGranularity);
            expectedResults.add(result);
        }
        queryResponseTemplate = StringUtils.replace((String)queryResponseTemplate, (String)"%%EXPECTED_QUERY_GRANULARITY%%", (String)this.jsonMapper.writeValueAsString(expectedResults));
        this.queryHelper.testQueriesFromString(queryResponseTemplate);
    }

    private void checkNumberOfSegments(int numExpectedSegments) {
        ITRetryUtil.retryUntilTrue(() -> {
            int metadataSegmentCount = this.coordinator.getSegments(this.fullDatasourceName).size();
            LOG.info("Current metadata segment count: %d, expected: %d", new Object[]{metadataSegmentCount, numExpectedSegments});
            return metadataSegmentCount == numExpectedSegments;
        }, (String)"Segment count check");
    }

    private void checkCompactionIntervals(List<String> expectedIntervals) {
        HashSet<String> expectedIntervalsSet = new HashSet<String>(expectedIntervals);
        ITRetryUtil.retryUntilTrue(() -> {
            HashSet intervalsAfterCompaction = new HashSet(this.coordinator.getSegmentIntervals(this.fullDatasourceName));
            System.out.println("ACTUAL: " + intervalsAfterCompaction);
            System.out.println("EXPECTED: " + expectedIntervalsSet);
            return intervalsAfterCompaction.equals(expectedIntervalsSet);
        }, (String)"Compaction interval check");
    }

    private String getQueryResponseTemplate(String queryResourcePath) {
        String queryResponseTemplate;
        try {
            InputStream is = AbstractITBatchIndexTest.class.getResourceAsStream(queryResourcePath);
            queryResponseTemplate = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            queryResponseTemplate = StringUtils.replace((String)queryResponseTemplate, (String)"%%DATASOURCE%%", (String)this.fullDatasourceName);
        }
        catch (IOException e) {
            throw new ISE((Throwable)e, "could not read query file: %s", new Object[]{queryResourcePath});
        }
        return queryResponseTemplate;
    }
}

