/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.inject.Inject;
import java.io.Closeable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.coordinator.CoordinatorDynamicConfig;
import org.apache.druid.testing.clients.CoordinatorResourceTestClient;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;
import org.testng.Assert;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"batch-index", "quickstart-compatible"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITIndexerTest
extends AbstractITBatchIndexTest {
    private static final String INDEX_TASK = "/indexer/wikipedia_index_task.json";
    private static final String INDEX_QUERIES_RESOURCE = "/indexer/wikipedia_index_queries.json";
    private static final String INDEX_DATASOURCE = "wikipedia_index_test";
    private static final String INDEX_WITH_TIMESTAMP_TASK = "/indexer/wikipedia_with_timestamp_index_task.json";
    private static final String INDEX_WITH_TIMESTAMP_QUERIES_RESOURCE = "/indexer/wikipedia_index_queries.json";
    private static final String INDEX_WITH_TIMESTAMP_DATASOURCE = "wikipedia_with_timestamp_index_test";
    private static final String REINDEX_TASK = "/indexer/wikipedia_reindex_task.json";
    private static final String REINDEX_TASK_WITH_DRUID_INPUT_SOURCE = "/indexer/wikipedia_reindex_druid_input_source_task.json";
    private static final String REINDEX_QUERIES_RESOURCE = "/indexer/wikipedia_reindex_queries.json";
    private static final String REINDEX_DATASOURCE = "wikipedia_reindex_test";
    private static final String MERGE_INDEX_TASK = "/indexer/wikipedia_merge_index_task.json";
    private static final String MERGE_INDEX_QUERIES_RESOURCE = "/indexer/wikipedia_merge_index_queries.json";
    private static final String MERGE_INDEX_DATASOURCE = "wikipedia_merge_index_test";
    private static final String MERGE_REINDEX_TASK = "/indexer/wikipedia_merge_reindex_task.json";
    private static final String MERGE_REINDEX_TASK_WITH_DRUID_INPUT_SOURCE = "/indexer/wikipedia_merge_reindex_druid_input_source_task.json";
    private static final String MERGE_REINDEX_QUERIES_RESOURCE = "/indexer/wikipedia_merge_index_queries.json";
    private static final String MERGE_REINDEX_DATASOURCE = "wikipedia_merge_reindex_test";
    private static final String INDEX_WITH_MERGE_COLUMN_LIMIT_TASK = "/indexer/wikipedia_index_with_merge_column_limit_task.json";
    private static final String INDEX_WITH_MERGE_COLUMN_LIMIT_DATASOURCE = "wikipedia_index_with_merge_column_limit_test";
    private static final String GET_LOCKED_INTERVALS = "wikipedia_index_get_locked_intervals_test";
    private static final CoordinatorDynamicConfig DYNAMIC_CONFIG_PAUSED = CoordinatorDynamicConfig.builder().withPauseCoordination(true).build();
    private static final CoordinatorDynamicConfig DYNAMIC_CONFIG_DEFAULT = CoordinatorDynamicConfig.builder().build();
    @Inject
    CoordinatorResourceTestClient coordinatorClient;

    @Test
    public void testIndexData() throws Exception {
        String reindexDatasource = "wikipedia_reindex_test-testIndexData";
        String reindexDatasourceWithDruidInputSource = "wikipedia_reindex_test-testIndexData-druidInputSource";
        try (Closeable ignored1 = this.unloader(INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix());
             Closeable ignored2 = this.unloader("wikipedia_reindex_test-testIndexData" + this.config.getExtraDatasourceNameSuffix());
             Closeable ignored3 = this.unloader("wikipedia_reindex_test-testIndexData-druidInputSource" + this.config.getExtraDatasourceNameSuffix());){
            Function<String, String> transform = spec -> {
                try {
                    return StringUtils.replace((String)spec, (String)"%%SEGMENT_AVAIL_TIMEOUT_MILLIS%%", (String)this.jsonMapper.writeValueAsString((Object)"0"));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            };
            this.doIndexTest(INDEX_DATASOURCE, INDEX_TASK, transform, "/indexer/wikipedia_index_queries.json", false, true, true, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
            this.doReindexTest(INDEX_DATASOURCE, "wikipedia_reindex_test-testIndexData", REINDEX_TASK, REINDEX_QUERIES_RESOURCE, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
            this.doReindexTest(INDEX_DATASOURCE, "wikipedia_reindex_test-testIndexData-druidInputSource", REINDEX_TASK_WITH_DRUID_INPUT_SOURCE, REINDEX_QUERIES_RESOURCE, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
        }
    }

    @Test
    public void testReIndexDataWithTimestamp() throws Exception {
        String reindexDatasource = "wikipedia_reindex_test-testReIndexDataWithTimestamp";
        String reindexDatasourceWithDruidInputSource = "wikipedia_reindex_test-testReIndexDataWithTimestamp-druidInputSource";
        try (Closeable ignored1 = this.unloader(INDEX_WITH_TIMESTAMP_DATASOURCE + this.config.getExtraDatasourceNameSuffix());
             Closeable ignored2 = this.unloader("wikipedia_reindex_test-testReIndexDataWithTimestamp" + this.config.getExtraDatasourceNameSuffix());
             Closeable ignored3 = this.unloader("wikipedia_reindex_test-testReIndexDataWithTimestamp-druidInputSource" + this.config.getExtraDatasourceNameSuffix());){
            this.doIndexTest(INDEX_WITH_TIMESTAMP_DATASOURCE, INDEX_WITH_TIMESTAMP_TASK, "/indexer/wikipedia_index_queries.json", false, true, true, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
            this.doReindexTest(INDEX_WITH_TIMESTAMP_DATASOURCE, "wikipedia_reindex_test-testReIndexDataWithTimestamp", REINDEX_TASK, REINDEX_QUERIES_RESOURCE, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
            this.doReindexTest(INDEX_WITH_TIMESTAMP_DATASOURCE, "wikipedia_reindex_test-testReIndexDataWithTimestamp-druidInputSource", REINDEX_TASK_WITH_DRUID_INPUT_SOURCE, REINDEX_QUERIES_RESOURCE, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
        }
    }

    @Test
    public void testReIndexWithNonExistingDatasource() throws Exception {
        Pair dummyPair = new Pair((Object)false, (Object)false);
        String fullBaseDatasourceName = "nonExistingDatasource2904";
        String fullReindexDatasourceName = "newDatasource123";
        String taskSpec = StringUtils.replace((String)ITIndexerTest.getResourceAsString(REINDEX_TASK_WITH_DRUID_INPUT_SOURCE), (String)"%%DATASOURCE%%", (String)"nonExistingDatasource2904");
        taskSpec = StringUtils.replace((String)taskSpec, (String)"%%REINDEX_DATASOURCE%%", (String)"newDatasource123");
        this.submitTaskAndWait(taskSpec, "newDatasource123", false, false, (Pair<Boolean, Boolean>)dummyPair);
    }

    @Test
    public void testMERGEIndexData() throws Exception {
        String reindexDatasource = "wikipedia_merge_reindex_test-testMergeIndexData";
        String reindexDatasourceWithDruidInputSource = "wikipedia_merge_reindex_test-testMergeReIndexData-druidInputSource";
        try (Closeable ignored1 = this.unloader(MERGE_INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix());
             Closeable ignored2 = this.unloader("wikipedia_merge_reindex_test-testMergeIndexData" + this.config.getExtraDatasourceNameSuffix());
             Closeable ignored3 = this.unloader("wikipedia_merge_reindex_test-testMergeReIndexData-druidInputSource" + this.config.getExtraDatasourceNameSuffix());){
            this.doIndexTest(MERGE_INDEX_DATASOURCE, MERGE_INDEX_TASK, "/indexer/wikipedia_merge_index_queries.json", false, true, true, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
            this.doReindexTest(MERGE_INDEX_DATASOURCE, "wikipedia_merge_reindex_test-testMergeIndexData", MERGE_REINDEX_TASK, "/indexer/wikipedia_merge_index_queries.json", (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
            this.doReindexTest(MERGE_INDEX_DATASOURCE, "wikipedia_merge_reindex_test-testMergeReIndexData-druidInputSource", MERGE_REINDEX_TASK_WITH_DRUID_INPUT_SOURCE, "/indexer/wikipedia_merge_index_queries.json", (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
        }
    }

    @Test
    public void testIndexDataAwaitSegmentAvailability() throws Exception {
        try (Closeable ignored1 = this.unloader(INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix());){
            Function<String, String> transform = spec -> {
                try {
                    return StringUtils.replace((String)spec, (String)"%%SEGMENT_AVAIL_TIMEOUT_MILLIS%%", (String)this.jsonMapper.writeValueAsString((Object)"600000"));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            };
            this.doIndexTest(INDEX_DATASOURCE, INDEX_TASK, transform, "/indexer/wikipedia_index_queries.json", false, true, true, (Pair<Boolean, Boolean>)new Pair((Object)true, (Object)true));
        }
    }

    @Test
    public void testIndexDataAwaitSegmentAvailabilityFailsButTaskSucceeds() throws Exception {
        try (Closeable ignored1 = this.unloader(INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix());){
            this.coordinatorClient.postDynamicConfig(DYNAMIC_CONFIG_PAUSED);
            Function<String, String> transform = spec -> {
                try {
                    return StringUtils.replace((String)spec, (String)"%%SEGMENT_AVAIL_TIMEOUT_MILLIS%%", (String)this.jsonMapper.writeValueAsString((Object)"1"));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            };
            this.doIndexTest(INDEX_DATASOURCE, INDEX_TASK, transform, "/indexer/wikipedia_index_queries.json", false, false, false, (Pair<Boolean, Boolean>)new Pair((Object)true, (Object)false));
            this.coordinatorClient.postDynamicConfig(DYNAMIC_CONFIG_DEFAULT);
            ITRetryUtil.retryUntilTrue(() -> this.coordinator.areSegmentsLoaded(INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix()), (String)"Segment Load");
        }
    }

    @Test
    public void testIndexWithMergeColumnLimitData() throws Exception {
        try (Closeable ignored1 = this.unloader(INDEX_WITH_MERGE_COLUMN_LIMIT_DATASOURCE + this.config.getExtraDatasourceNameSuffix());){
            this.doIndexTest(INDEX_WITH_MERGE_COLUMN_LIMIT_DATASOURCE, INDEX_WITH_MERGE_COLUMN_LIMIT_TASK, "/indexer/wikipedia_index_queries.json", false, true, true, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
        }
    }

    @Test
    public void testGetLockedIntervals() throws Exception {
        String datasourceName = GET_LOCKED_INTERVALS + this.config.getExtraDatasourceNameSuffix();
        try (Closeable ignored = this.unloader(datasourceName);){
            this.submitIndexTask(INDEX_TASK, datasourceName);
            Map<String, Integer> minTaskPriority = Collections.singletonMap(datasourceName, 0);
            HashMap lockedIntervals = new HashMap();
            ITRetryUtil.retryUntilFalse(() -> {
                lockedIntervals.clear();
                lockedIntervals.putAll(this.indexer.getLockedIntervals(minTaskPriority));
                return lockedIntervals.isEmpty();
            }, (String)"Verify Intervals are Locked");
            Assert.assertEquals((int)lockedIntervals.size(), (int)1);
            Assert.assertEquals((Collection)((Collection)lockedIntervals.get(datasourceName)), Collections.singletonList(Intervals.of((String)"2013-08-31/2013-09-02")));
            ITRetryUtil.retryUntilTrue(() -> this.coordinator.areSegmentsLoaded(datasourceName), (String)"Segment Load");
        }
    }

    @Test
    public void testJsonFunctions() throws Exception {
        String taskSpec = ITIndexerTest.getResourceAsString("/indexer/json_path_index_task.json");
        this.submitTaskAndWait(taskSpec, "json_path_index_test", false, true, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
        this.doTestQuery("json_path_index_test", "/indexer/json_path_index_queries.json");
    }
}

