/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.indexing.overlord.supervisor.SupervisorStateManager;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.sql.http.SqlQuery;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.utils.EventSerializer;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.testing.utils.JsonEventSerializer;
import org.apache.druid.testing.utils.SqlQueryWithResults;
import org.apache.druid.testing.utils.StreamEventWriter;
import org.apache.druid.testing.utils.WikipediaStreamEventStreamGenerator;
import org.apache.druid.tests.indexer.AbstractKafkaIndexingServiceTest;
import org.apache.druid.tests.indexer.AbstractStreamIndexingTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"kafka-transactional-index-slow"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITNilColumnTest
extends AbstractKafkaIndexingServiceTest {
    private static final Logger LOG = new Logger(ITNilColumnTest.class);
    private static final String NIL_DIM1 = "nilDim1";
    private static final String NIL_DIM2 = "nilDim2";
    private final List<String> dimensions = new ArrayList<String>(DEFAULT_DIMENSIONS.size() + 2);

    public ITNilColumnTest() {
        this.dimensions.add(NIL_DIM1);
        this.dimensions.addAll(DEFAULT_DIMENSIONS);
        this.dimensions.add(NIL_DIM2);
    }

    @Override
    public String getTestNamePrefix() {
        return "nil-column-test";
    }

    @BeforeClass
    public void beforeClass() throws Exception {
        this.doBeforeClass();
    }

    @Test
    public void testQueryNilColumnBeforeAndAfterPublishingSegments() throws Exception {
        AbstractStreamIndexingTest.GeneratedTestConfig generatedTestConfig = new AbstractStreamIndexingTest.GeneratedTestConfig(this, "inputFormat", ITNilColumnTest.getResourceAsString(JSON_INPUT_FORMAT_PATH), this.dimensions);
        try (Closeable closer = this.createResourceCloser(generatedTestConfig);
             StreamEventWriter streamEventWriter = this.createStreamEventWriter(this.config, true);){
            String taskSpec = generatedTestConfig.getStreamIngestionPropsTransform().apply(ITNilColumnTest.getResourceAsString(SUPERVISOR_SPEC_TEMPLATE_PATH));
            LOG.info("supervisorSpec: [%s]\n", new Object[]{taskSpec});
            generatedTestConfig.setSupervisorId(this.indexer.submitSupervisor(taskSpec));
            LOG.info("Submitted supervisor", new Object[0]);
            WikipediaStreamEventStreamGenerator streamGenerator = new WikipediaStreamEventStreamGenerator((EventSerializer)new JsonEventSerializer(this.jsonMapper), 6, 100L);
            long numWritten = streamGenerator.run(generatedTestConfig.getStreamName(), streamEventWriter, 10, FIRST_EVENT_TIME);
            ITRetryUtil.retryUntil(() -> SupervisorStateManager.BasicState.RUNNING.equals((Object)this.indexer.getSupervisorStatus(generatedTestConfig.getSupervisorId())), (boolean)true, (long)10000L, (int)30, (String)"Waiting for supervisor to be healthy");
            this.dataLoaderHelper.waitUntilDatasourceIsReady(generatedTestConfig.getFullDatasourceName());
            List<SqlQueryWithResults> queryWithResults = ITNilColumnTest.getQueryWithResults(generatedTestConfig);
            this.sqlQueryHelper.testQueriesFromString(this.jsonMapper.writeValueAsString(queryWithResults));
            List<SqlQueryWithResults> metadataQueryWithResults = this.getMetadataQueryWithResults(generatedTestConfig);
            this.sqlQueryHelper.testQueriesFromString(this.jsonMapper.writeValueAsString(metadataQueryWithResults));
            this.indexer.terminateSupervisor(generatedTestConfig.getSupervisorId());
            ITRetryUtil.retryUntilTrue(() -> {
                List tasks = this.indexer.getRunningTasks().stream().filter(task -> task.getId().contains(generatedTestConfig.getFullDatasourceName())).filter(task -> "index_kafka".equals(task.getType())).collect(Collectors.toList());
                LOG.info("[%s] tasks are running", new Object[]{tasks.stream().map(task -> {
                    try {
                        return this.jsonMapper.writeValueAsString(task);
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                }).collect(Collectors.toList())});
                return tasks.isEmpty();
            }, (String)"Waiting for all tasks to stop");
            this.dataLoaderHelper.waitUntilDatasourceIsReady(generatedTestConfig.getFullDatasourceName());
            this.verifyIngestedData(generatedTestConfig, numWritten);
            this.sqlQueryHelper.testQueriesFromString(this.jsonMapper.writeValueAsString(queryWithResults));
            this.sqlQueryHelper.testQueriesFromString(this.jsonMapper.writeValueAsString(metadataQueryWithResults));
        }
    }

    private static List<SqlQueryWithResults> getQueryWithResults(AbstractStreamIndexingTest.GeneratedTestConfig generatedTestConfig) {
        return ImmutableList.of((Object)new SqlQueryWithResults(new SqlQuery(StringUtils.format((String)"SELECT count(*) FROM \"%s\" WHERE %s IS NOT NULL OR %s IS NOT NULL", (Object[])new Object[]{generatedTestConfig.getFullDatasourceName(), NIL_DIM1, NIL_DIM2}), null, false, false, false, null, null), (List)ImmutableList.of((Object)ImmutableMap.of((Object)"EXPR$0", (Object)0))));
    }

    private List<SqlQueryWithResults> getMetadataQueryWithResults(AbstractStreamIndexingTest.GeneratedTestConfig generatedTestConfig) {
        return ImmutableList.of((Object)new SqlQueryWithResults(new SqlQuery(StringUtils.format((String)"SELECT COLUMN_NAME, IS_NULLABLE, DATA_TYPE FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = '%s' AND COLUMN_NAME IN ('%s', '%s')", (Object[])new Object[]{generatedTestConfig.getFullDatasourceName(), NIL_DIM1, NIL_DIM2}), null, false, false, false, null, null), (List)ImmutableList.of((Object)ImmutableMap.of((Object)"COLUMN_NAME", (Object)NIL_DIM1, (Object)"IS_NULLABLE", (Object)"YES", (Object)"DATA_TYPE", (Object)"VARCHAR"), (Object)ImmutableMap.of((Object)"COLUMN_NAME", (Object)NIL_DIM2, (Object)"IS_NULLABLE", (Object)"YES", (Object)"DATA_TYPE", (Object)"VARCHAR"))));
    }
}

