/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Closeable;
import java.util.function.Function;
import org.apache.druid.indexer.partitions.HashedPartitionsSpec;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;
import org.apache.druid.timeline.partition.HashPartitionFunction;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"perfect-rollup-parallel-batch-index", "shuffle-deep-store"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITPerfectRollupParallelIndexTest
extends AbstractITBatchIndexTest {
    private static final String INDEX_TASK = "/indexer/wikipedia_parallel_index_task.json";
    private static final String INDEX_QUERIES_RESOURCE = "/indexer/wikipedia_parallel_index_queries.json";
    private static final String INDEX_DATASOURCE = "wikipedia_parallel_index_test";
    private static final String INDEX_INGEST_SEGMENT_DATASOURCE = "wikipedia_parallel_ingest_segment_index_test";
    private static final String INDEX_INGEST_SEGMENT_TASK = "/indexer/wikipedia_parallel_ingest_segment_index_task.json";
    private static final String INDEX_DRUID_INPUT_SOURCE_DATASOURCE = "wikipedia_parallel_druid_input_source_index_test";
    private static final String INDEX_DRUID_INPUT_SOURCE_TASK = "/indexer/wikipedia_parallel_druid_input_source_index_task.json";

    @DataProvider
    public static Object[][] resources() {
        return new Object[][]{{new HashedPartitionsSpec(null, Integer.valueOf(2), null, HashPartitionFunction.MURMUR3_32_ABS)}, {new HashedPartitionsSpec(null, Integer.valueOf(2), null, null)}, {new SingleDimensionPartitionsSpec(Integer.valueOf(2), null, "namespace", false)}};
    }

    @Test(dataProvider="resources")
    public void testIndexData(PartitionsSpec partitionsSpec) throws Exception {
        try (Closeable ignored1 = this.unloader(INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix());
             Closeable ignored2 = this.unloader(INDEX_INGEST_SEGMENT_DATASOURCE + this.config.getExtraDatasourceNameSuffix());
             Closeable ignored3 = this.unloader(INDEX_DRUID_INPUT_SOURCE_DATASOURCE + this.config.getExtraDatasourceNameSuffix());){
            boolean forceGuaranteedRollup = partitionsSpec.isForceGuaranteedRollupCompatible();
            Assert.assertTrue((boolean)forceGuaranteedRollup, (String)"parititionSpec does not support perfect rollup");
            Function<String, String> rollupTransform = spec -> {
                try {
                    spec = StringUtils.replace((String)spec, (String)"%%FORCE_GUARANTEED_ROLLUP%%", (String)Boolean.toString(true));
                    spec = StringUtils.replace((String)spec, (String)"%%SEGMENT_AVAIL_TIMEOUT_MILLIS%%", (String)this.jsonMapper.writeValueAsString((Object)"0"));
                    return StringUtils.replace((String)spec, (String)"%%PARTITIONS_SPEC%%", (String)this.jsonMapper.writeValueAsString((Object)partitionsSpec));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            };
            this.doIndexTest(INDEX_DATASOURCE, INDEX_TASK, rollupTransform, INDEX_QUERIES_RESOURCE, false, true, true, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
            this.doReindexTest(INDEX_DATASOURCE, INDEX_INGEST_SEGMENT_DATASOURCE, rollupTransform, INDEX_INGEST_SEGMENT_TASK, INDEX_QUERIES_RESOURCE, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
            this.doReindexTest(INDEX_DATASOURCE, INDEX_DRUID_INPUT_SOURCE_DATASOURCE, rollupTransform, INDEX_DRUID_INPUT_SOURCE_TASK, INDEX_QUERIES_RESOURCE, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
        }
    }
}

