/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.util.UUID;
import java.util.function.Function;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;
import org.testng.Assert;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"s3-ingestion"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITS3OverrideCredentialsIndexTest
extends AbstractITBatchIndexTest {
    private static final String INDEX_TASK_WITH_OVERRIDE = "/indexer/wikipedia_override_credentials_index_task.json";
    private static final String INDEX_TASK_WITHOUT_OVERRIDE = "/indexer/wikipedia_cloud_simple_index_task.json";
    private static final String INDEX_QUERIES_RESOURCE = "/indexer/wikipedia_index_queries.json";
    private static final String INPUT_SOURCE_OBJECTS_KEY = "objects";
    private static final String WIKIPEDIA_DATA_1 = "wikipedia_index_data1.json";
    private static final String WIKIPEDIA_DATA_2 = "wikipedia_index_data2.json";
    private static final String WIKIPEDIA_DATA_3 = "wikipedia_index_data3.json";
    private static final ImmutableList INPUT_SOURCE_OBJECTS_VALUE = ImmutableList.of((Object)ImmutableMap.of((Object)"bucket", (Object)"%%BUCKET%%", (Object)"path", (Object)"%%PATH%%wikipedia_index_data1.json"), (Object)ImmutableMap.of((Object)"bucket", (Object)"%%BUCKET%%", (Object)"path", (Object)"%%PATH%%wikipedia_index_data2.json"), (Object)ImmutableMap.of((Object)"bucket", (Object)"%%BUCKET%%", (Object)"path", (Object)"%%PATH%%wikipedia_index_data3.json"));

    @Test
    public void testS3WithValidOverrideCredentialsIndexDataShouldSucceed() throws Exception {
        String indexDatasource = "wikipedia_index_test_" + UUID.randomUUID();
        try (Closeable ignored1 = this.unloader(indexDatasource + this.config.getExtraDatasourceNameSuffix());){
            Function<String, String> s3PropsTransform = spec -> {
                try {
                    String inputSourceValue = this.jsonMapper.writeValueAsString((Object)INPUT_SOURCE_OBJECTS_VALUE);
                    inputSourceValue = StringUtils.replace((String)inputSourceValue, (String)"%%BUCKET%%", (String)this.config.getCloudBucket());
                    inputSourceValue = StringUtils.replace((String)inputSourceValue, (String)"%%PATH%%", (String)this.config.getCloudPath());
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_CONFIG%%", (String)this.jsonMapper.writeValueAsString((Object)ImmutableMap.of((Object)"accessKeyId", (Object)ImmutableMap.of((Object)"type", (Object)"environment", (Object)"variable", (Object)"OVERRIDE_S3_ACCESS_KEY"), (Object)"secretAccessKey", (Object)ImmutableMap.of((Object)"type", (Object)"environment", (Object)"variable", (Object)"OVERRIDE_S3_SECRET_KEY"))));
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_TYPE%%", (String)"s3");
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_PROPERTY_KEY%%", (String)INPUT_SOURCE_OBJECTS_KEY);
                    return StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_PROPERTY_VALUE%%", (String)inputSourceValue);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            this.doIndexTest(indexDatasource, INDEX_TASK_WITH_OVERRIDE, s3PropsTransform, INDEX_QUERIES_RESOURCE, false, true, true, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testS3WithoutOverrideCredentialsIndexDataShouldFailed() throws Exception {
        String indexDatasource = "wikipedia_index_test_" + UUID.randomUUID();
        try {
            Function<String, String> s3PropsTransform = spec -> {
                try {
                    String inputSourceValue = this.jsonMapper.writeValueAsString((Object)INPUT_SOURCE_OBJECTS_VALUE);
                    inputSourceValue = StringUtils.replace((String)inputSourceValue, (String)"%%BUCKET%%", (String)this.config.getCloudBucket());
                    inputSourceValue = StringUtils.replace((String)inputSourceValue, (String)"%%PATH%%", (String)this.config.getCloudPath());
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_TYPE%%", (String)"s3");
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_PROPERTY_KEY%%", (String)INPUT_SOURCE_OBJECTS_KEY);
                    return StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_PROPERTY_VALUE%%", (String)inputSourceValue);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            String fullDatasourceName = indexDatasource + this.config.getExtraDatasourceNameSuffix();
            String taskSpec = s3PropsTransform.apply(StringUtils.replace((String)ITS3OverrideCredentialsIndexTest.getResourceAsString(INDEX_TASK_WITHOUT_OVERRIDE), (String)"%%DATASOURCE%%", (String)fullDatasourceName));
            String taskID = this.indexer.submitTask(taskSpec);
            this.indexer.waitUntilTaskFails(taskID);
            TaskStatusPlus taskStatusPlus = this.indexer.getTaskStatus(taskID);
            Assert.assertEquals((Object)taskStatusPlus.getStatusCode(), (Object)TaskState.FAILED);
            Assert.assertNotNull((Object)taskStatusPlus.getErrorMsg());
            Assert.assertTrue((boolean)taskStatusPlus.getErrorMsg().contains("com.amazonaws.services.s3.model.AmazonS3Exception"), (String)"Expect task to fail with AmazonS3Exception");
        }
        finally {
            this.closeQuietly(this.unloader(indexDatasource + this.config.getExtraDatasourceNameSuffix()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testS3WithInvalidOverrideCredentialsIndexDataShouldFailed() throws Exception {
        String indexDatasource = "wikipedia_index_test_" + UUID.randomUUID();
        try {
            Function<String, String> s3PropsTransform = spec -> {
                try {
                    String inputSourceValue = this.jsonMapper.writeValueAsString((Object)INPUT_SOURCE_OBJECTS_VALUE);
                    inputSourceValue = StringUtils.replace((String)inputSourceValue, (String)"%%BUCKET%%", (String)this.config.getCloudBucket());
                    inputSourceValue = StringUtils.replace((String)inputSourceValue, (String)"%%PATH%%", (String)this.config.getCloudPath());
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_CONFIG%%", (String)this.jsonMapper.writeValueAsString((Object)ImmutableMap.of((Object)"accessKeyId", (Object)ImmutableMap.of((Object)"type", (Object)"environment", (Object)"variable", (Object)"INVALID_ACCESS_KEY"), (Object)"secretAccessKey", (Object)ImmutableMap.of((Object)"type", (Object)"environment", (Object)"variable", (Object)"INVALID_SECRET_KEY"))));
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_TYPE%%", (String)"s3");
                    spec = StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_PROPERTY_KEY%%", (String)INPUT_SOURCE_OBJECTS_KEY);
                    return StringUtils.replace((String)spec, (String)"%%INPUT_SOURCE_PROPERTY_VALUE%%", (String)inputSourceValue);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            };
            String fullDatasourceName = indexDatasource + this.config.getExtraDatasourceNameSuffix();
            String taskSpec = s3PropsTransform.apply(StringUtils.replace((String)ITS3OverrideCredentialsIndexTest.getResourceAsString(INDEX_TASK_WITH_OVERRIDE), (String)"%%DATASOURCE%%", (String)fullDatasourceName));
            String taskID = this.indexer.submitTask(taskSpec);
            this.indexer.waitUntilTaskFails(taskID);
            TaskStatusPlus taskStatusPlus = this.indexer.getTaskStatus(taskID);
            Assert.assertEquals((Object)taskStatusPlus.getStatusCode(), (Object)TaskState.FAILED);
            Assert.assertNotNull((Object)taskStatusPlus.getErrorMsg());
            Assert.assertTrue((boolean)taskStatusPlus.getErrorMsg().contains("IllegalArgumentException: Access key cannot be null"), (String)"Expect task to fail with IllegalArgumentException: Access key cannot be null");
        }
        finally {
            this.closeQuietly(this.unloader(indexDatasource + this.config.getExtraDatasourceNameSuffix()));
        }
    }

    private void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

