/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.Closeable;
import java.util.function.Function;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"batch-index"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITSystemTableBatchIndexTaskTest
extends AbstractITBatchIndexTest {
    private static final Logger LOG = new Logger(ITSystemTableBatchIndexTaskTest.class);
    private static final String INDEX_TASK = "/indexer/wikipedia_index_task.json";
    private static final String SYSTEM_QUERIES_RESOURCE = "/indexer/sys_segment_batch_index_queries.json";
    private static final String INDEX_DATASOURCE = "wikipedia_index_test";

    @Test
    public void testIndexData() throws Exception {
        LOG.info("Starting batch index sys table queries", new Object[0]);
        try (Closeable ignored = this.unloader(INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix());){
            Function<String, String> transform = spec -> {
                try {
                    return StringUtils.replace((String)spec, (String)"%%SEGMENT_AVAIL_TIMEOUT_MILLIS%%", (String)this.jsonMapper.writeValueAsString((Object)"0"));
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            };
            this.doIndexTestSqlTest(INDEX_DATASOURCE, INDEX_TASK, SYSTEM_QUERIES_RESOURCE, transform);
        }
    }
}

