/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.indexer;

import java.io.Closeable;
import java.io.IOException;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.tests.indexer.AbstractITBatchIndexTest;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"batch-index", "quickstart-compatible"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITTransformTest
extends AbstractITBatchIndexTest {
    private static final String INDEX_TASK_WITH_FIREHOSE = "/indexer/wikipedia_index_task_with_transform.json";
    private static final String INDEX_TASK_WITH_INPUT_SOURCE = "/indexer/wikipedia_index_task_with_inputsource_transform.json";
    private static final String INDEX_QUERIES_RESOURCE = "/indexer/wikipedia_index_queries_with_transform.json";
    private static final String INDEX_DATASOURCE = "wikipedia_index_test";
    private static final String REINDEX_TASK = "/indexer/wikipedia_reindex_task_with_transforms.json";
    private static final String REINDEX_TASK_WITH_DRUID_INPUT_SOURCE = "/indexer/wikipedia_reindex_druid_input_source_task_with_transforms.json";
    private static final String REINDEX_QUERIES_RESOURCE = "/indexer/wikipedia_reindex_queries_with_transforms.json";
    private static final String REINDEX_DATASOURCE = "wikipedia_reindex_test";

    @Test
    public void testIndexAndReIndexWithTransformSpec() throws IOException {
        String reindexDatasourceWithDruidInputSource = "wikipedia_reindex_test-druidInputSource";
        try (Closeable ignored1 = this.unloader(INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix());
             Closeable ignored2 = this.unloader("wikipedia_reindex_test-druidInputSource" + this.config.getExtraDatasourceNameSuffix());){
            this.doIndexTest(INDEX_DATASOURCE, INDEX_TASK_WITH_INPUT_SOURCE, INDEX_QUERIES_RESOURCE, false, true, true, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
            this.doReindexTest(INDEX_DATASOURCE, "wikipedia_reindex_test-druidInputSource", REINDEX_TASK_WITH_DRUID_INPUT_SOURCE, REINDEX_QUERIES_RESOURCE, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
        }
    }

    @Test(enabled=false)
    public void testIndexAndReIndexUsingIngestSegmentWithTransforms() throws IOException {
        String reindexDatasource = "wikipedia_reindex_test-testIndexData";
        try (Closeable ignored1 = this.unloader(INDEX_DATASOURCE + this.config.getExtraDatasourceNameSuffix());
             Closeable ignored2 = this.unloader("wikipedia_reindex_test-testIndexData" + this.config.getExtraDatasourceNameSuffix());){
            this.doIndexTest(INDEX_DATASOURCE, INDEX_TASK_WITH_INPUT_SOURCE, INDEX_QUERIES_RESOURCE, false, true, true, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
            this.doReindexTest(INDEX_DATASOURCE, "wikipedia_reindex_test-testIndexData", REINDEX_TASK, REINDEX_QUERIES_RESOURCE, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
        }
    }

    @Test(enabled=false)
    public void testIndexWithFirehoseAndTransforms() throws IOException {
        String indexDatasource = "wikipedia_index_test-firehose";
        try (Closeable ignored1 = this.unloader("wikipedia_index_test-firehose" + this.config.getExtraDatasourceNameSuffix());){
            this.doIndexTest("wikipedia_index_test-firehose", INDEX_TASK_WITH_FIREHOSE, INDEX_QUERIES_RESOURCE, false, true, true, (Pair<Boolean, Boolean>)new Pair((Object)false, (Object)false));
        }
    }
}

