/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.parallelized;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.utils.KafkaUtil;
import org.apache.druid.tests.indexer.AbstractKafkaIndexingServiceTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"kafka-data-format"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITKafkaIndexingServiceDataFormatTest
extends AbstractKafkaIndexingServiceTest {
    private static final boolean TRANSACTION_DISABLED = false;
    private static final boolean TRANSACTION_ENABLED = true;
    @Inject
    @Json
    private ObjectMapper jsonMapper;
    @Inject
    private IntegrationTestingConfig config;

    @DataProvider(parallel=true)
    public static Object[][] resources() throws IOException {
        ArrayList resources = new ArrayList();
        List<String> dataFormats = ITKafkaIndexingServiceDataFormatTest.listDataFormatResources();
        for (String eachFormat : dataFormats) {
            Map<String, String> spec = ITKafkaIndexingServiceDataFormatTest.findTestSpecs(String.join((CharSequence)"/", "/stream/data", eachFormat));
            String serializerPath = spec.get("serializer");
            spec.forEach((k, path) -> {
                if (!"serializer".equals(k)) {
                    resources.add(new Object[]{false, serializerPath, k, path});
                    resources.add(new Object[]{true, serializerPath, k, path});
                }
            });
        }
        return (Object[][])resources.toArray((T[])new Object[0][]);
    }

    @BeforeClass
    public void beforeClass() throws Exception {
        this.doBeforeClass();
    }

    @Test(dataProvider="resources")
    public void testIndexData(boolean transactionEnabled, String serializerPath, String parserType, String specPath) throws Exception {
        Map testConfig = KafkaUtil.getAdditionalKafkaTestConfigFromProperties((IntegrationTestingConfig)this.config);
        boolean txnEnable = Boolean.parseBoolean(testConfig.getOrDefault("transactionEnabled", "false"));
        if (txnEnable != transactionEnabled) {
            return;
        }
        this.doTestIndexDataStableState(txnEnable, serializerPath, parserType, specPath);
    }

    @Override
    public String getTestNamePrefix() {
        return "kafka_data_format";
    }
}

