/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.parallelized;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.tests.indexer.AbstractKinesisIndexingServiceTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"kinesis-data-format"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITKinesisIndexingServiceDataFormatTest
extends AbstractKinesisIndexingServiceTest {
    @Inject
    @Json
    private ObjectMapper jsonMapper;

    @DataProvider(parallel=true)
    public static Object[][] resources() throws IOException {
        ArrayList resources = new ArrayList();
        List<String> dataFormats = ITKinesisIndexingServiceDataFormatTest.listDataFormatResources();
        for (String eachFormat : dataFormats) {
            Map<String, String> spec = ITKinesisIndexingServiceDataFormatTest.findTestSpecs(String.join((CharSequence)"/", "/stream/data", eachFormat));
            String serializerPath = spec.get("serializer");
            spec.forEach((k, path) -> {
                if (!"serializer".equals(k)) {
                    resources.add(new Object[]{serializerPath, k, path});
                }
            });
        }
        return (Object[][])resources.toArray((T[])new Object[0][]);
    }

    @BeforeClass
    public void beforeClass() throws Exception {
        this.doBeforeClass();
    }

    @Test(dataProvider="resources")
    public void testIndexData(String serializerPath, String parserType, String specPath) throws Exception {
        this.doTestIndexDataStableState(null, serializerPath, parserType, specPath);
    }

    @Override
    public String getTestNamePrefix() {
        return "kinesis_data_format";
    }
}

