/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.query;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import org.apache.calcite.avatica.AvaticaSqlException;
import org.apache.druid.https.SSLClientConfig;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.utils.DataLoaderHelper;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"query"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITJdbcQueryTest {
    private static final Logger LOG = new Logger(ITJdbcQueryTest.class);
    private static final String WIKIPEDIA_DATA_SOURCE = "wikipedia_editstream";
    private static final String CONNECTION_TEMPLATE = "jdbc:avatica:remote:url=%s/druid/v2/sql/avatica/";
    private static final String TLS_CONNECTION_TEMPLATE = "jdbc:avatica:remote:url=%s/druid/v2/sql/avatica/;truststore=%s;truststore_password=%s;keystore=%s;keystore_password=%s;key_password=%s";
    private static final String QUERY_TEMPLATE = "SELECT \"user\", SUM(\"added\"), COUNT(*)FROM \"wikipedia\" WHERE \"__time\" >= CURRENT_TIMESTAMP - INTERVAL '10' YEAR AND \"language\" = %sGROUP BY 1 ORDER BY 3 DESC LIMIT 10";
    private static final String QUERY = StringUtils.format((String)"SELECT \"user\", SUM(\"added\"), COUNT(*)FROM \"wikipedia\" WHERE \"__time\" >= CURRENT_TIMESTAMP - INTERVAL '10' YEAR AND \"language\" = %sGROUP BY 1 ORDER BY 3 DESC LIMIT 10", (Object[])new Object[]{"'en'"});
    private static final String QUERY_PARAMETERIZED = StringUtils.format((String)"SELECT \"user\", SUM(\"added\"), COUNT(*)FROM \"wikipedia\" WHERE \"__time\" >= CURRENT_TIMESTAMP - INTERVAL '10' YEAR AND \"language\" = %sGROUP BY 1 ORDER BY 3 DESC LIMIT 10", (Object[])new Object[]{"?"});
    private String[] connections;
    private Properties connectionProperties;
    @Inject
    private IntegrationTestingConfig config;
    @Inject
    SSLClientConfig sslConfig;
    @Inject
    private DataLoaderHelper dataLoaderHelper;

    @BeforeMethod
    public void before() {
        this.connectionProperties = new Properties();
        this.connectionProperties.setProperty("user", "admin");
        this.connectionProperties.setProperty("password", "priest");
        this.connections = new String[]{StringUtils.format((String)CONNECTION_TEMPLATE, (Object[])new Object[]{this.config.getRouterUrl()}), StringUtils.format((String)CONNECTION_TEMPLATE, (Object[])new Object[]{this.config.getBrokerUrl()}), StringUtils.format((String)TLS_CONNECTION_TEMPLATE, (Object[])new Object[]{this.config.getRouterTLSUrl(), this.sslConfig.getTrustStorePath(), this.sslConfig.getTrustStorePasswordProvider().getPassword(), this.sslConfig.getKeyStorePath(), this.sslConfig.getKeyStorePasswordProvider().getPassword(), this.sslConfig.getKeyManagerPasswordProvider().getPassword()}), StringUtils.format((String)TLS_CONNECTION_TEMPLATE, (Object[])new Object[]{this.config.getBrokerTLSUrl(), this.sslConfig.getTrustStorePath(), this.sslConfig.getTrustStorePasswordProvider().getPassword(), this.sslConfig.getKeyStorePath(), this.sslConfig.getKeyStorePasswordProvider().getPassword(), this.sslConfig.getKeyManagerPasswordProvider().getPassword()})};
        this.dataLoaderHelper.waitUntilDatasourceIsReady(WIKIPEDIA_DATA_SOURCE);
    }

    @Test
    public void testJdbcMetadata() {
        for (String url : this.connections) {
            try (Connection connection = DriverManager.getConnection(url, this.connectionProperties);){
                DatabaseMetaData metadata = connection.getMetaData();
                ArrayList<String> catalogs = new ArrayList<String>();
                ResultSet catalogsMetadata = metadata.getCatalogs();
                while (catalogsMetadata.next()) {
                    String catalog = catalogsMetadata.getString(1);
                    catalogs.add(catalog);
                }
                LOG.info("catalogs %s", new Object[]{catalogs});
                Assert.assertEquals(catalogs, (Collection)ImmutableList.of((Object)"druid"));
                HashSet<String> schemas = new HashSet<String>();
                ResultSet schemasMetadata = metadata.getSchemas("druid", null);
                while (schemasMetadata.next()) {
                    String schema = schemasMetadata.getString(1);
                    schemas.add(schema);
                }
                LOG.info("'druid' catalog schemas %s", new Object[]{schemas});
                Assert.assertTrue((boolean)schemas.containsAll((Collection<?>)ImmutableList.of((Object)"INFORMATION_SCHEMA", (Object)"druid", (Object)"lookup", (Object)"sys")));
                HashSet<String> druidTables = new HashSet<String>();
                ResultSet tablesMetadata = metadata.getTables("druid", "druid", null, null);
                while (tablesMetadata.next()) {
                    String table = tablesMetadata.getString(3);
                    druidTables.add(table);
                }
                LOG.info("'druid' schema tables %s", new Object[]{druidTables});
                Assert.assertTrue((boolean)druidTables.containsAll((Collection<?>)ImmutableList.of((Object)"twitterstream", (Object)"wikipedia", (Object)WIKIPEDIA_DATA_SOURCE)));
                HashSet<String> wikiColumns = new HashSet<String>();
                ResultSet columnsMetadata = metadata.getColumns("druid", "druid", WIKIPEDIA_DATA_SOURCE, null);
                while (columnsMetadata.next()) {
                    String column = columnsMetadata.getString(4);
                    wikiColumns.add(column);
                }
                LOG.info("'%s' columns %s", new Object[]{WIKIPEDIA_DATA_SOURCE, wikiColumns});
                Assert.assertTrue((boolean)wikiColumns.containsAll((Collection<?>)ImmutableList.of((Object)"added", (Object)"city", (Object)"delta", (Object)"language")));
            }
            catch (SQLException throwables) {
                Assert.fail((String)throwables.getMessage());
            }
        }
    }

    @Test
    public void testJdbcStatementQuery() {
        for (String url : this.connections) {
            try (Connection connection = DriverManager.getConnection(url, this.connectionProperties);
                 Statement statement = connection.createStatement();){
                ResultSet resultSet = statement.executeQuery(QUERY);
                int resultRowCount = 0;
                while (resultSet.next()) {
                    ++resultRowCount;
                    LOG.info("%s,%s,%s", new Object[]{resultSet.getString(1), resultSet.getLong(2), resultSet.getLong(3)});
                }
                Assert.assertEquals((int)resultRowCount, (int)10);
                resultSet.close();
            }
            catch (SQLException throwables) {
                Assert.fail((String)throwables.getMessage());
            }
        }
    }

    @Test
    public void testJdbcPrepareStatementQuery() {
        for (String url : this.connections) {
            try (Connection connection = DriverManager.getConnection(url, this.connectionProperties);
                 PreparedStatement statement = connection.prepareStatement(QUERY_PARAMETERIZED);){
                statement.setString(1, "en");
                ResultSet resultSet = statement.executeQuery();
                int resultRowCount = 0;
                while (resultSet.next()) {
                    ++resultRowCount;
                    LOG.info("%s,%s,%s", new Object[]{resultSet.getString(1), resultSet.getLong(2), resultSet.getLong(3)});
                }
                Assert.assertEquals((int)resultRowCount, (int)10);
                resultSet.close();
            }
            catch (SQLException throwables) {
                Assert.fail((String)throwables.getMessage());
            }
        }
    }

    @Test(expectedExceptions={AvaticaSqlException.class}, expectedExceptionsMessageRegExp=".* Parameter at position \\[0] is not bound")
    public void testJdbcPrepareStatementQueryMissingParameters() throws SQLException {
        for (String url : this.connections) {
            try (Connection connection = DriverManager.getConnection(url, this.connectionProperties);
                 PreparedStatement statement = connection.prepareStatement(QUERY_PARAMETERIZED);){
                ResultSet resultSet = statement.executeQuery();
                Throwable throwable = null;
                if (resultSet == null) continue;
                if (throwable != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                resultSet.close();
            }
        }
    }
}

