/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.query;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.clients.CoordinatorResourceTestClient;
import org.apache.druid.testing.clients.QueryResourceTestClient;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.testing.utils.QueryResultVerifier;
import org.apache.druid.testing.utils.QueryWithResults;
import org.apache.druid.testing.utils.TestQueryHelper;
import org.apache.druid.tests.indexer.AbstractIndexerTest;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"query-retry"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITQueryRetryTestOnMissingSegments {
    private static final String WIKIPEDIA_DATA_SOURCE = "wikipedia_editstream";
    private static final String QUERIES_RESOURCE = "/queries/wikipedia_editstream_queries_query_retry_test.json";
    @Inject
    private CoordinatorResourceTestClient coordinatorClient;
    @Inject
    private TestQueryHelper queryHelper;
    @Inject
    private QueryResourceTestClient queryClient;
    @Inject
    private IntegrationTestingConfig config;
    @Inject
    private ObjectMapper jsonMapper;

    @BeforeMethod
    public void before() {
        ITRetryUtil.retryUntilTrue(() -> this.coordinatorClient.areSegmentsLoaded(WIKIPEDIA_DATA_SOURCE), (String)"wikipedia segment load");
    }

    @Test
    public void testWithRetriesDisabledPartialResultDisallowed() throws Exception {
        this.testQueries(this.buildQuery(0, false), Expectation.QUERY_FAILURE);
    }

    @Test
    public void testWithRetriesDisabledPartialResultAllowed() throws Exception {
        this.testQueries(this.buildQuery(0, true), Expectation.INCORRECT_RESULT);
    }

    @Test
    public void testWithRetriesEnabledPartialResultDisallowed() throws Exception {
        this.testQueries(this.buildQuery(1, false), Expectation.ALL_SUCCESS);
    }

    private void testQueries(String queryWithResultsStr, Expectation expectation) throws Exception {
        List queries = (List)this.jsonMapper.readValue(queryWithResultsStr, (TypeReference)new TypeReference<List<QueryWithResults>>(){});
        this.testQueries(queries, expectation);
    }

    private void testQueries(List<QueryWithResults> queries, Expectation expectation) throws Exception {
        int querySuccess = 0;
        int queryFailure = 0;
        int resultMatches = 0;
        int resultMismatches = 0;
        for (QueryWithResults queryWithResult : queries) {
            StatusResponseHolder responseHolder = (StatusResponseHolder)this.queryClient.queryAsync(this.queryHelper.getQueryURL(this.config.getBrokerUrl()), queryWithResult.getQuery()).get();
            if (responseHolder.getStatus().getCode() == HttpResponseStatus.OK.getCode()) {
                ++querySuccess;
                List result = (List)this.jsonMapper.readValue(responseHolder.getContent(), (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
                if (!QueryResultVerifier.compareResults((Iterable)result, (Iterable)queryWithResult.getExpectedResults(), (List)queryWithResult.getFieldsToTest()).isSuccess()) {
                    if (expectation != Expectation.INCORRECT_RESULT) {
                        throw new ISE("Incorrect query results for query %s \n expectedResults: %s \n actualResults : %s", new Object[]{queryWithResult.getQuery(), this.jsonMapper.writeValueAsString((Object)queryWithResult.getExpectedResults()), this.jsonMapper.writeValueAsString((Object)result)});
                    }
                    ++resultMismatches;
                    continue;
                }
                ++resultMatches;
                continue;
            }
            if (responseHolder.getStatus().getCode() == HttpResponseStatus.INTERNAL_SERVER_ERROR.getCode() && expectation == Expectation.QUERY_FAILURE) {
                Map response = (Map)this.jsonMapper.readValue(responseHolder.getContent(), Map.class);
                String errorMessage = (String)response.get("errorMessage");
                Assert.assertNotNull((Object)errorMessage, (String)"errorMessage");
                Assert.assertTrue((boolean)errorMessage.contains("No results found for segments"));
                ++queryFailure;
                continue;
            }
            throw new ISE("Unexpected failure, code: [%s], content: [%s]", new Object[]{responseHolder.getStatus(), responseHolder.getContent()});
        }
        switch (expectation) {
            case ALL_SUCCESS: {
                Assert.assertEquals((int)querySuccess, (int)1);
                Assert.assertEquals((int)queryFailure, (int)0);
                Assert.assertEquals((int)resultMatches, (int)1);
                Assert.assertEquals((int)resultMismatches, (int)0);
                break;
            }
            case QUERY_FAILURE: {
                Assert.assertEquals((int)querySuccess, (int)0);
                Assert.assertEquals((int)queryFailure, (int)1);
                Assert.assertEquals((int)resultMatches, (int)0);
                Assert.assertEquals((int)resultMismatches, (int)0);
                break;
            }
            case INCORRECT_RESULT: {
                Assert.assertEquals((int)querySuccess, (int)1);
                Assert.assertEquals((int)queryFailure, (int)0);
                Assert.assertEquals((int)resultMatches, (int)0);
                Assert.assertEquals((int)resultMismatches, (int)1);
                break;
            }
            default: {
                throw new ISE("Unknown expectation[%s]", new Object[]{expectation});
            }
        }
    }

    private String buildQuery(int numRetriesOnMissingSegments, boolean allowPartialResults) throws IOException {
        return StringUtils.replace((String)AbstractIndexerTest.getResourceAsString(QUERIES_RESOURCE), (String)"%%CONTEXT%%", (String)this.jsonMapper.writeValueAsString(ITQueryRetryTestOnMissingSegments.buildContext(numRetriesOnMissingSegments, allowPartialResults)));
    }

    private static Map<String, Object> buildContext(int numRetriesOnMissingSegments, boolean allowPartialResults) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("useCache", false);
        context.put("useResultLevelCache", false);
        context.put("numRetriesOnMissingSegments", numRetriesOnMissingSegments);
        context.put("returnPartialResults", allowPartialResults);
        context.put("query-retry-test", true);
        return context;
    }

    private static enum Expectation {
        ALL_SUCCESS,
        INCORRECT_RESULT,
        QUERY_FAILURE;

    }
}

