/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.query.QueryException;
import org.apache.druid.sql.http.SqlQuery;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.clients.SqlResourceTestClient;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.utils.DataLoaderHelper;
import org.apache.druid.testing.utils.SqlTestQueryHelper;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"query"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITSqlCancelTest {
    private static final String WIKIPEDIA_DATA_SOURCE = "wikipedia_editstream";
    private static final String QUERY = "SELECT sleep(CASE WHEN added > 0 THEN 1 ELSE 0 END) FROM wikipedia_editstream WHERE added > 0 LIMIT 15";
    private static final int NUM_QUERIES = 3;
    @Inject
    private DataLoaderHelper dataLoaderHelper;
    @Inject
    private SqlTestQueryHelper sqlHelper;
    @Inject
    private SqlResourceTestClient sqlClient;
    @Inject
    private IntegrationTestingConfig config;
    @Inject
    private ObjectMapper jsonMapper;

    @BeforeMethod
    public void before() {
        this.dataLoaderHelper.waitUntilDatasourceIsReady(WIKIPEDIA_DATA_SOURCE);
    }

    @Test
    public void testCancelValidQuery() throws Exception {
        String queryId = "sql-cancel-test";
        ArrayList<Future> queryResponseFutures = new ArrayList<Future>();
        for (int i = 0; i < 3; ++i) {
            queryResponseFutures.add(this.sqlClient.queryAsync(this.sqlHelper.getQueryURL(this.config.getRouterUrl()), (Object)new SqlQuery(QUERY, null, false, false, false, (Map)ImmutableMap.of((Object)"sqlQueryId", (Object)"sql-cancel-test"), null)));
        }
        Thread.sleep(1000L);
        HttpResponseStatus responseStatus = this.sqlClient.cancelQuery(this.sqlHelper.getCancelUrl(this.config.getRouterUrl(), "sql-cancel-test"), 1000L);
        if (!responseStatus.equals((Object)HttpResponseStatus.ACCEPTED)) {
            throw new RE("Failed to cancel query [%s]. Response code was [%s]", new Object[]{"sql-cancel-test", responseStatus});
        }
        for (Future queryResponseFuture : queryResponseFutures) {
            StatusResponseHolder queryResponse = (StatusResponseHolder)queryResponseFuture.get(1L, TimeUnit.SECONDS);
            if (!queryResponse.getStatus().equals((Object)HttpResponseStatus.INTERNAL_SERVER_ERROR)) {
                throw new ISE("Query is not canceled after cancel request", new Object[0]);
            }
            QueryException queryException = (QueryException)this.jsonMapper.readValue(queryResponse.getContent(), QueryException.class);
            if ("Query cancelled".equals(queryException.getErrorCode())) continue;
            throw new ISE("Expected error code [%s], actual [%s]", new Object[]{"Query cancelled", queryException.getErrorCode()});
        }
    }

    @Test
    public void testCancelInvalidQuery() throws Exception {
        Future queryResponseFuture = this.sqlClient.queryAsync(this.sqlHelper.getQueryURL(this.config.getRouterUrl()), (Object)new SqlQuery(QUERY, null, false, false, false, (Map)ImmutableMap.of((Object)"sqlQueryId", (Object)"validId"), null));
        Thread.sleep(1000L);
        HttpResponseStatus responseStatus = this.sqlClient.cancelQuery(this.sqlHelper.getCancelUrl(this.config.getRouterUrl(), "invalidId"), 1000L);
        if (!responseStatus.equals((Object)HttpResponseStatus.NOT_FOUND)) {
            throw new RE("Expected http response [%s], actual response [%s]", new Object[]{HttpResponseStatus.NOT_FOUND, responseStatus});
        }
        StatusResponseHolder queryResponse = (StatusResponseHolder)queryResponseFuture.get(30L, TimeUnit.SECONDS);
        if (!queryResponse.getStatus().equals((Object)HttpResponseStatus.OK)) {
            throw new ISE("Cancel request failed with status[%s] and content[%s]", new Object[]{queryResponse.getStatus(), queryResponse.getContent()});
        }
    }
}

