/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.query;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Future;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.query.Druids;
import org.apache.druid.query.QueryCapacityExceededException;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.CountAggregatorFactory;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.clients.CoordinatorResourceTestClient;
import org.apache.druid.testing.clients.QueryResourceTestClient;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.testing.utils.TestQueryHelper;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"query"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITWikipediaQueryTest {
    private static final Logger LOG = new Logger(ITWikipediaQueryTest.class);
    public static final String WIKIPEDIA_DATA_SOURCE = "wikipedia_editstream";
    private static final String WIKI_LOOKUP = "wiki-simple";
    private static final String WIKIPEDIA_QUERIES_RESOURCE = "/queries/wikipedia_editstream_queries.json";
    private static final String WIKIPEDIA_LOOKUP_RESOURCE = "/queries/wiki-lookup-config.json";
    @Inject
    private CoordinatorResourceTestClient coordinatorClient;
    @Inject
    private TestQueryHelper queryHelper;
    @Inject
    private QueryResourceTestClient queryClient;
    @Inject
    private IntegrationTestingConfig config;

    @BeforeMethod
    public void before() throws Exception {
        ITRetryUtil.retryUntilTrue(() -> this.coordinatorClient.areSegmentsLoaded(WIKIPEDIA_DATA_SOURCE), (String)"wikipedia segment load");
        if (!this.coordinatorClient.areLookupsLoaded(WIKI_LOOKUP)) {
            this.coordinatorClient.initializeLookups(WIKIPEDIA_LOOKUP_RESOURCE);
            ITRetryUtil.retryUntilTrue(() -> this.coordinatorClient.areLookupsLoaded(WIKI_LOOKUP), (String)"wikipedia lookup load");
        }
    }

    @DataProvider
    public static Object[][] encodingCombination() {
        return new Object[][]{{"application/json", null}, {"application/json", "application/json"}, {"application/json", "application/x-jackson-smile"}, {"application/x-jackson-smile", null}, {"application/x-jackson-smile", "application/json"}, {"application/x-jackson-smile", "application/x-jackson-smile"}};
    }

    @Test(dataProvider="encodingCombination")
    public void testWikipediaQueriesFromFile(String contentType, String accept) throws Exception {
        TestQueryHelper queryHelper = this.queryHelper.withEncoding(contentType, accept);
        queryHelper.testQueriesFromFile(WIKIPEDIA_QUERIES_RESOURCE);
    }

    @Test
    public void testQueryLaningLaneIsLimited() throws Exception {
        ITRetryUtil.retryUntil(() -> {
            int numQueries = 50;
            ArrayList<Future> futures = new ArrayList<Future>(50);
            for (int i = 0; i < 50; ++i) {
                futures.add(this.queryClient.queryAsync(this.queryHelper.getQueryURL(this.config.getBrokerUrl()), (Object)this.getQueryBuilder().build()));
            }
            int success = 0;
            int limited = 0;
            for (Future future : futures) {
                StatusResponseHolder status = (StatusResponseHolder)future.get();
                if (status.getStatus().getCode() == 429) {
                    ++limited;
                    Assert.assertTrue((boolean)status.getContent().contains(QueryCapacityExceededException.makeLaneErrorMessage((String)"one", (int)1)));
                    continue;
                }
                if (status.getStatus().getCode() != HttpResponseStatus.OK.getCode()) continue;
                ++success;
            }
            try {
                Assert.assertTrue((success > 0 ? 1 : 0) != 0);
                Assert.assertTrue((limited > 0 ? 1 : 0) != 0);
                return true;
            }
            catch (AssertionError ae) {
                LOG.error((Throwable)((Object)ae), "Got assertion error in testQueryLaningLaneIsLimited", new Object[0]);
                return false;
            }
        }, (boolean)true, (long)5000L, (int)3, (String)"testQueryLaningLaneIsLimited");
        StatusResponseHolder followUp = (StatusResponseHolder)this.queryClient.queryAsync(this.queryHelper.getQueryURL(this.config.getBrokerUrl()), (Object)this.getQueryBuilder().build()).get();
        Assert.assertEquals((int)followUp.getStatus().getCode(), (int)HttpResponseStatus.OK.getCode());
        StatusResponseHolder andAnother = (StatusResponseHolder)this.queryClient.queryAsync(this.queryHelper.getQueryURL(this.config.getBrokerUrl()), (Object)this.getQueryBuilder().build()).get();
        Assert.assertEquals((int)andAnother.getStatus().getCode(), (int)HttpResponseStatus.OK.getCode());
    }

    @Test
    public void testQueryLaningWithNoLane() throws Exception {
        int numQueries = 50;
        ArrayList<Future> futures = new ArrayList<Future>(50);
        for (int i = 0; i < 50; ++i) {
            futures.add(this.queryClient.queryAsync(this.queryHelper.getQueryURL(this.config.getBrokerUrl()), (Object)this.getQueryBuilder().context((Map)ImmutableMap.of((Object)"queryId", (Object)UUID.randomUUID().toString())).build()));
        }
        int success = 0;
        int limited = 0;
        for (Future future : futures) {
            StatusResponseHolder status = (StatusResponseHolder)future.get();
            if (status.getStatus().getCode() == 429) {
                ++limited;
                continue;
            }
            if (status.getStatus().getCode() != HttpResponseStatus.OK.getCode()) continue;
            ++success;
        }
        Assert.assertTrue((success > 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)limited, (int)0);
    }

    private Druids.TimeseriesQueryBuilder getQueryBuilder() {
        return Druids.newTimeseriesQueryBuilder().dataSource(WIKIPEDIA_DATA_SOURCE).aggregators(new AggregatorFactory[]{new CountAggregatorFactory("chocula")}).intervals("2013-01-01T00:00:00.000/2013-01-08T00:00:00.000").context((Map)ImmutableMap.of((Object)"lane", (Object)"one", (Object)"queryId", (Object)UUID.randomUUID().toString()));
    }
}

