/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.security;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.AvaticaSqlException;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.guice.annotations.Client;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.jackson.JacksonUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.CredentialedHttpClient;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.auth.BasicCredentials;
import org.apache.druid.java.util.http.client.auth.Credentials;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.clients.CoordinatorResourceTestClient;
import org.apache.druid.testing.utils.HttpUtil;
import org.apache.druid.testing.utils.TestQueryHelper;
import org.apache.druid.tests.indexer.AbstractIndexerTest;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class AbstractAuthConfigurationTest {
    private static final Logger LOG = new Logger(AbstractAuthConfigurationTest.class);
    protected static final String INVALID_NAME = "invalid%2Fname";
    protected static final String SYSTEM_SCHEMA_SEGMENTS_RESULTS_RESOURCE = "/results/auth_test_sys_schema_segments.json";
    protected static final String SYSTEM_SCHEMA_SERVER_SEGMENTS_RESULTS_RESOURCE = "/results/auth_test_sys_schema_server_segments.json";
    protected static final String SYSTEM_SCHEMA_SERVERS_RESULTS_RESOURCE = "/results/auth_test_sys_schema_servers.json";
    protected static final String SYSTEM_SCHEMA_TASKS_RESULTS_RESOURCE = "/results/auth_test_sys_schema_tasks.json";
    protected static final String SYS_SCHEMA_SEGMENTS_QUERY = "SELECT * FROM sys.segments WHERE datasource IN ('auth_test')";
    protected static final String SYS_SCHEMA_SERVERS_QUERY = "SELECT * FROM sys.servers WHERE tier IS NOT NULL";
    protected static final String SYS_SCHEMA_SERVER_SEGMENTS_QUERY = "SELECT * FROM sys.server_segments WHERE segment_id LIKE 'auth_test%'";
    protected static final String SYS_SCHEMA_TASKS_QUERY = "SELECT * FROM sys.tasks WHERE datasource IN ('auth_test')";
    protected static final TypeReference<List<Map<String, Object>>> SYS_SCHEMA_RESULTS_TYPE_REFERENCE = new TypeReference<List<Map<String, Object>>>(){};
    protected static final List<ResourceAction> DATASOURCE_ONLY_PERMISSIONS = Collections.singletonList(new ResourceAction(new Resource("auth_test", "DATASOURCE"), Action.READ));
    protected static final List<ResourceAction> DATASOURCE_QUERY_CONTEXT_PERMISSIONS = ImmutableList.of((Object)new ResourceAction(new Resource("auth_test", "DATASOURCE"), Action.READ), (Object)new ResourceAction(new Resource("auth_test_ctx", "QUERY_CONTEXT"), Action.WRITE));
    protected static final List<ResourceAction> DATASOURCE_SYS_PERMISSIONS = ImmutableList.of((Object)new ResourceAction(new Resource("auth_test", "DATASOURCE"), Action.READ), (Object)new ResourceAction(new Resource("segments", "SYSTEM_TABLE"), Action.READ), (Object)new ResourceAction(new Resource("servers", "SYSTEM_TABLE"), Action.READ), (Object)new ResourceAction(new Resource("server_segments", "SYSTEM_TABLE"), Action.READ), (Object)new ResourceAction(new Resource("tasks", "SYSTEM_TABLE"), Action.READ));
    protected static final List<ResourceAction> DATASOURCE_SYS_STATE_PERMISSIONS = ImmutableList.of((Object)new ResourceAction(new Resource("auth_test", "DATASOURCE"), Action.READ), (Object)new ResourceAction(new Resource(".*", "SYSTEM_TABLE"), Action.READ), (Object)new ResourceAction(new Resource(".*", "STATE"), Action.READ));
    protected static final List<ResourceAction> STATE_ONLY_PERMISSIONS = ImmutableList.of((Object)new ResourceAction(new Resource(".*", "STATE"), Action.READ), (Object)new ResourceAction(new Resource(".*", "SYSTEM_TABLE"), Action.READ));
    protected List<Map<String, Object>> adminSegments;
    protected List<Map<String, Object>> adminTasks;
    protected List<Map<String, Object>> adminServers;
    protected List<Map<String, Object>> adminServerSegments;
    @Inject
    protected IntegrationTestingConfig config;
    @Inject
    protected ObjectMapper jsonMapper;
    @Inject
    @Client
    protected HttpClient httpClient;
    @Inject
    protected CoordinatorResourceTestClient coordinatorClient;
    protected Map<User, HttpClient> httpClients;

    protected abstract void setupDatasourceOnlyUser() throws Exception;

    protected abstract void setupDatasourceAndContextParamsUser() throws Exception;

    protected abstract void setupDatasourceAndSysTableUser() throws Exception;

    protected abstract void setupDatasourceAndSysAndStateUser() throws Exception;

    protected abstract void setupSysTableAndStateOnlyUser() throws Exception;

    protected abstract void setupTestSpecificHttpClients() throws Exception;

    protected abstract String getAuthenticatorName();

    protected abstract String getAuthorizerName();

    protected abstract String getExpectedAvaticaAuthError();

    protected abstract String getExpectedAvaticaAuthzError();

    protected abstract Properties getAvaticaConnectionPropertiesForInvalidAdmin();

    protected abstract Properties getAvaticaConnectionPropertiesForUser(User var1);

    @Test
    public void test_systemSchemaAccess_admin() throws Exception {
        HttpClient adminClient = this.getHttpClient(User.ADMIN);
        this.checkNodeAccess(adminClient);
        LOG.info("Checking sys.segments query as admin...", new Object[0]);
        this.verifySystemSchemaQuery(adminClient, SYS_SCHEMA_SEGMENTS_QUERY, this.adminSegments);
        LOG.info("Checking sys.servers query as admin...", new Object[0]);
        this.verifySystemSchemaServerQuery(adminClient, SYS_SCHEMA_SERVERS_QUERY, AbstractAuthConfigurationTest.getServersWithoutCurrentSize(this.adminServers));
        LOG.info("Checking sys.server_segments query as admin...", new Object[0]);
        this.verifySystemSchemaQuery(adminClient, SYS_SCHEMA_SERVER_SEGMENTS_QUERY, this.adminServerSegments);
        LOG.info("Checking sys.tasks query as admin...", new Object[0]);
        this.verifySystemSchemaQuery(adminClient, SYS_SCHEMA_TASKS_QUERY, this.adminTasks);
    }

    @Test
    public void test_systemSchemaAccess_datasourceOnlyUser() throws Exception {
        HttpClient datasourceOnlyUserClient = this.getHttpClient(User.DATASOURCE_ONLY_USER);
        HttpUtil.makeRequest((HttpClient)datasourceOnlyUserClient, (HttpMethod)HttpMethod.GET, (String)(this.config.getBrokerUrl() + "/druid/v2/datasources/auth_test"), null);
        LOG.info("Checking sys.segments query as datasourceOnlyUser...", new Object[0]);
        String expectedMsg = "{\"Access-Check-Result\":\"Unauthorized\"}";
        this.verifySystemSchemaQueryFailure(datasourceOnlyUserClient, SYS_SCHEMA_SEGMENTS_QUERY, HttpResponseStatus.FORBIDDEN, "{\"Access-Check-Result\":\"Unauthorized\"}");
        LOG.info("Checking sys.servers query as datasourceOnlyUser...", new Object[0]);
        this.verifySystemSchemaQueryFailure(datasourceOnlyUserClient, SYS_SCHEMA_SERVERS_QUERY, HttpResponseStatus.FORBIDDEN, "{\"Access-Check-Result\":\"Unauthorized\"}");
        LOG.info("Checking sys.server_segments query as datasourceOnlyUser...", new Object[0]);
        this.verifySystemSchemaQueryFailure(datasourceOnlyUserClient, SYS_SCHEMA_SERVER_SEGMENTS_QUERY, HttpResponseStatus.FORBIDDEN, "{\"Access-Check-Result\":\"Unauthorized\"}");
        LOG.info("Checking sys.tasks query as datasourceOnlyUser...", new Object[0]);
        this.verifySystemSchemaQueryFailure(datasourceOnlyUserClient, SYS_SCHEMA_TASKS_QUERY, HttpResponseStatus.FORBIDDEN, "{\"Access-Check-Result\":\"Unauthorized\"}");
    }

    @Test
    public void test_systemSchemaAccess_datasourceAndSysUser() throws Exception {
        HttpClient datasourceAndSysUserClient = this.getHttpClient(User.DATASOURCE_AND_SYS_USER);
        HttpUtil.makeRequest((HttpClient)datasourceAndSysUserClient, (HttpMethod)HttpMethod.GET, (String)(this.config.getBrokerUrl() + "/druid/v2/datasources/auth_test"), null);
        LOG.info("Checking sys.segments query as datasourceAndSysUser...", new Object[0]);
        this.verifySystemSchemaQuery(datasourceAndSysUserClient, SYS_SCHEMA_SEGMENTS_QUERY, this.adminSegments.stream().filter(segmentEntry -> "auth_test".equals(segmentEntry.get("datasource"))).collect(Collectors.toList()));
        LOG.info("Checking sys.servers query as datasourceAndSysUser...", new Object[0]);
        this.verifySystemSchemaQueryFailure(datasourceAndSysUserClient, SYS_SCHEMA_SERVERS_QUERY, HttpResponseStatus.FORBIDDEN, "{\"Access-Check-Result\":\"Insufficient permission to view servers: Unauthorized\"}");
        LOG.info("Checking sys.server_segments query as datasourceAndSysUser...", new Object[0]);
        this.verifySystemSchemaQueryFailure(datasourceAndSysUserClient, SYS_SCHEMA_SERVER_SEGMENTS_QUERY, HttpResponseStatus.FORBIDDEN, "{\"Access-Check-Result\":\"Insufficient permission to view servers: Unauthorized\"}");
        LOG.info("Checking sys.tasks query as datasourceAndSysUser...", new Object[0]);
        this.verifySystemSchemaQuery(datasourceAndSysUserClient, SYS_SCHEMA_TASKS_QUERY, this.adminTasks.stream().filter(taskEntry -> "auth_test".equals(taskEntry.get("datasource"))).collect(Collectors.toList()));
    }

    @Test
    public void test_systemSchemaAccess_datasourceAndSysWithStateUser() throws Exception {
        HttpClient datasourceWithStateUserClient = this.getHttpClient(User.DATASOURCE_WITH_STATE_USER);
        HttpUtil.makeRequest((HttpClient)datasourceWithStateUserClient, (HttpMethod)HttpMethod.GET, (String)(this.config.getBrokerUrl() + "/status"), null);
        LOG.info("Checking sys.segments query as datasourceWithStateUser...", new Object[0]);
        this.verifySystemSchemaQuery(datasourceWithStateUserClient, SYS_SCHEMA_SEGMENTS_QUERY, this.adminSegments.stream().filter(segmentEntry -> "auth_test".equals(segmentEntry.get("datasource"))).collect(Collectors.toList()));
        LOG.info("Checking sys.servers query as datasourceWithStateUser...", new Object[0]);
        this.verifySystemSchemaServerQuery(datasourceWithStateUserClient, SYS_SCHEMA_SERVERS_QUERY, this.adminServers);
        LOG.info("Checking sys.server_segments query as datasourceWithStateUser...", new Object[0]);
        this.verifySystemSchemaQuery(datasourceWithStateUserClient, SYS_SCHEMA_SERVER_SEGMENTS_QUERY, this.adminServerSegments.stream().filter(serverSegmentEntry -> ((String)serverSegmentEntry.get("segment_id")).contains("auth_test")).collect(Collectors.toList()));
        LOG.info("Checking sys.tasks query as datasourceWithStateUser...", new Object[0]);
        this.verifySystemSchemaQuery(datasourceWithStateUserClient, SYS_SCHEMA_TASKS_QUERY, this.adminTasks.stream().filter(taskEntry -> "auth_test".equals(taskEntry.get("datasource"))).collect(Collectors.toList()));
    }

    @Test
    public void test_systemSchemaAccess_stateOnlyUser() throws Exception {
        HttpClient stateOnlyUserClient = this.getHttpClient(User.STATE_ONLY_USER);
        HttpUtil.makeRequest((HttpClient)stateOnlyUserClient, (HttpMethod)HttpMethod.GET, (String)(this.config.getBrokerUrl() + "/status"), null);
        LOG.info("Checking sys.segments query as stateOnlyUser...", new Object[0]);
        this.verifySystemSchemaQuery(stateOnlyUserClient, SYS_SCHEMA_SEGMENTS_QUERY, Collections.emptyList());
        LOG.info("Checking sys.servers query as stateOnlyUser...", new Object[0]);
        this.verifySystemSchemaServerQuery(stateOnlyUserClient, SYS_SCHEMA_SERVERS_QUERY, this.adminServers);
        LOG.info("Checking sys.server_segments query as stateOnlyUser...", new Object[0]);
        this.verifySystemSchemaQuery(stateOnlyUserClient, SYS_SCHEMA_SERVER_SEGMENTS_QUERY, Collections.emptyList());
        LOG.info("Checking sys.tasks query as stateOnlyUser...", new Object[0]);
        this.verifySystemSchemaQuery(stateOnlyUserClient, SYS_SCHEMA_TASKS_QUERY, Collections.emptyList());
    }

    @Test
    public void test_unsecuredPathWithoutCredentials_allowed() {
        this.checkUnsecuredCoordinatorLoadQueuePath(this.httpClient);
    }

    @Test
    public void test_admin_loadStatus() throws Exception {
        this.checkLoadStatus(this.getHttpClient(User.ADMIN));
    }

    @Test
    public void test_admin_hasNodeAccess() {
        this.checkNodeAccess(this.getHttpClient(User.ADMIN));
    }

    @Test
    public void test_internalSystemUser_hasNodeAccess() {
        this.checkNodeAccess(this.getHttpClient(User.INTERNAL_SYSTEM));
    }

    @Test
    public void test_avaticaQuery_broker() {
        Properties properties = this.getAvaticaConnectionPropertiesForAdmin();
        this.testAvaticaQuery(properties, this.getBrokerAvacticaUrl());
        this.testAvaticaQuery(properties, StringUtils.maybeRemoveTrailingSlash((String)this.getBrokerAvacticaUrl()));
    }

    @Test
    public void test_avaticaQuery_router() {
        Properties properties = this.getAvaticaConnectionPropertiesForAdmin();
        this.testAvaticaQuery(properties, this.getRouterAvacticaUrl());
        this.testAvaticaQuery(properties, StringUtils.maybeRemoveTrailingSlash((String)this.getRouterAvacticaUrl()));
    }

    @Test
    public void test_avaticaQueryAuthFailure_broker() throws Exception {
        Properties properties = this.getAvaticaConnectionPropertiesForInvalidAdmin();
        this.testAvaticaAuthFailure(properties, this.getBrokerAvacticaUrl());
    }

    @Test
    public void test_avaticaQueryAuthFailure_router() throws Exception {
        Properties properties = this.getAvaticaConnectionPropertiesForInvalidAdmin();
        this.testAvaticaAuthFailure(properties, this.getRouterAvacticaUrl());
    }

    @Test
    public void test_avaticaQueryWithContext_datasourceOnlyUser_fail() throws Exception {
        Properties properties = this.getAvaticaConnectionPropertiesForUser(User.DATASOURCE_ONLY_USER);
        properties.setProperty("auth_test_ctx", "should-be-denied");
        this.testAvaticaAuthzFailure(properties, this.getRouterAvacticaUrl());
    }

    @Test
    public void test_avaticaQueryWithContext_datasourceAndContextParamsUser_succeed() {
        Properties properties = this.getAvaticaConnectionPropertiesForUser(User.DATASOURCE_AND_CONTEXT_PARAMS_USER);
        properties.setProperty("auth_test_ctx", "should-be-allowed");
        this.testAvaticaQuery(properties, this.getRouterAvacticaUrl());
    }

    @Test
    public void test_sqlQueryWithContext_datasourceOnlyUser_fail() throws Exception {
        String query = "select count(*) from auth_test";
        this.makeSQLQueryRequest(this.getHttpClient(User.DATASOURCE_ONLY_USER), "select count(*) from auth_test", (Map<String, Object>)ImmutableMap.of((Object)"auth_test_ctx", (Object)"should-be-denied"), HttpResponseStatus.FORBIDDEN);
    }

    @Test
    public void test_sqlQueryWithContext_datasourceAndContextParamsUser_succeed() throws Exception {
        String query = "select count(*) from auth_test";
        this.makeSQLQueryRequest(this.getHttpClient(User.DATASOURCE_AND_CONTEXT_PARAMS_USER), "select count(*) from auth_test", (Map<String, Object>)ImmutableMap.of((Object)"auth_test_ctx", (Object)"should-be-allowed"), HttpResponseStatus.OK);
    }

    @Test
    public void test_admin_optionsRequest() {
        this.verifyAdminOptionsRequest();
    }

    @Test
    public void test_authentication_invalidAuthName_fails() {
        this.verifyAuthenticationInvalidAuthNameFails();
    }

    @Test
    public void test_authorization_invalidAuthName_fails() {
        this.verifyAuthorizationInvalidAuthNameFails();
    }

    @Test
    public void test_groupMappings_invalidAuthName_fails() {
        this.verifyGroupMappingsInvalidAuthNameFails();
    }

    @Test
    public void testMaliciousUser() {
        this.verifyMaliciousUser();
    }

    protected HttpClient getHttpClient(User user) {
        return (HttpClient)Preconditions.checkNotNull((Object)this.httpClients.get((Object)user), (String)"http client for user[%s]", (Object[])new Object[]{user.getName()});
    }

    protected void setupHttpClientsAndUsers() throws Exception {
        this.setupHttpClients();
        this.setupDatasourceOnlyUser();
        this.setupDatasourceAndContextParamsUser();
        this.setupDatasourceAndSysTableUser();
        this.setupDatasourceAndSysAndStateUser();
        this.setupSysTableAndStateOnlyUser();
    }

    protected void checkNodeAccess(HttpClient httpClient) {
        HttpUtil.makeRequest((HttpClient)httpClient, (HttpMethod)HttpMethod.GET, (String)(this.config.getCoordinatorUrl() + "/status"), null);
        HttpUtil.makeRequest((HttpClient)httpClient, (HttpMethod)HttpMethod.GET, (String)(this.config.getOverlordUrl() + "/status"), null);
        HttpUtil.makeRequest((HttpClient)httpClient, (HttpMethod)HttpMethod.GET, (String)(this.config.getBrokerUrl() + "/status"), null);
        HttpUtil.makeRequest((HttpClient)httpClient, (HttpMethod)HttpMethod.GET, (String)(this.config.getHistoricalUrl() + "/status"), null);
        HttpUtil.makeRequest((HttpClient)httpClient, (HttpMethod)HttpMethod.GET, (String)(this.config.getRouterUrl() + "/status"), null);
    }

    protected void checkLoadStatus(HttpClient httpClient) throws Exception {
        this.checkLoadStatusSingle(httpClient, this.config.getCoordinatorUrl());
        this.checkLoadStatusSingle(httpClient, this.config.getOverlordUrl());
        this.checkLoadStatusSingle(httpClient, this.config.getBrokerUrl());
        this.checkLoadStatusSingle(httpClient, this.config.getHistoricalUrl());
        this.checkLoadStatusSingle(httpClient, this.config.getRouterUrl());
    }

    protected void testOptionsRequests(HttpClient httpClient) {
        HttpUtil.makeRequest((HttpClient)httpClient, (HttpMethod)HttpMethod.OPTIONS, (String)(this.config.getCoordinatorUrl() + "/status"), null);
        HttpUtil.makeRequest((HttpClient)httpClient, (HttpMethod)HttpMethod.OPTIONS, (String)(this.config.getOverlordUrl() + "/status"), null);
        HttpUtil.makeRequest((HttpClient)httpClient, (HttpMethod)HttpMethod.OPTIONS, (String)(this.config.getBrokerUrl() + "/status"), null);
        HttpUtil.makeRequest((HttpClient)httpClient, (HttpMethod)HttpMethod.OPTIONS, (String)(this.config.getHistoricalUrl() + "/status"), null);
        HttpUtil.makeRequest((HttpClient)httpClient, (HttpMethod)HttpMethod.OPTIONS, (String)(this.config.getRouterUrl() + "/status"), null);
    }

    protected void checkUnsecuredCoordinatorLoadQueuePath(HttpClient client) {
        HttpUtil.makeRequest((HttpClient)client, (HttpMethod)HttpMethod.GET, (String)(this.config.getCoordinatorUrl() + "/druid/coordinator/v1/loadqueue"), null);
    }

    private Properties getAvaticaConnectionPropertiesForAdmin() {
        return this.getAvaticaConnectionPropertiesForUser(User.ADMIN);
    }

    protected void testAvaticaQuery(Properties connectionProperties, String url) {
        LOG.info("URL: " + url, new Object[0]);
        try (Connection connection = DriverManager.getConnection(url, connectionProperties);
             Statement statement = connection.createStatement();){
            statement.setMaxRows(450);
            String query = "SELECT * FROM INFORMATION_SCHEMA.COLUMNS";
            ResultSet resultSet = statement.executeQuery(query);
            Assert.assertTrue((boolean)resultSet.next());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void testAvaticaAuthFailure(Properties connectionProperties, String url) throws Exception {
        this.testAvaticaAuthFailure(connectionProperties, url, this.getExpectedAvaticaAuthError());
    }

    protected void testAvaticaAuthzFailure(Properties connectionProperties, String url) throws Exception {
        this.testAvaticaAuthFailure(connectionProperties, url, this.getExpectedAvaticaAuthzError());
    }

    protected void testAvaticaAuthFailure(Properties connectionProperties, String url, String expectedError) throws Exception {
        LOG.info("URL: " + url, new Object[0]);
        try (Connection connection = DriverManager.getConnection(url, connectionProperties);
             Statement statement = connection.createStatement();){
            statement.setMaxRows(450);
            String query = "SELECT * FROM INFORMATION_SCHEMA.COLUMNS";
            statement.executeQuery(query);
        }
        catch (AvaticaSqlException ase) {
            Assert.assertEquals((String)ase.getErrorMessage(), (String)expectedError);
            return;
        }
        Assert.fail((String)"Test failed, did not get AvaticaSqlException.");
    }

    protected void checkLoadStatusSingle(HttpClient httpClient, String baseUrl) throws Exception {
        StatusResponseHolder holder = HttpUtil.makeRequest((HttpClient)httpClient, (HttpMethod)HttpMethod.GET, (String)(baseUrl + "/druid-ext/basic-security/authentication/loadStatus"), null);
        String content = holder.getContent();
        Map loadStatus = (Map)this.jsonMapper.readValue(content, JacksonUtils.TYPE_REFERENCE_MAP_STRING_BOOLEAN);
        String authenticatorName = this.getAuthenticatorName();
        Assert.assertNotNull(loadStatus.get(authenticatorName));
        Assert.assertTrue((boolean)((Boolean)loadStatus.get(authenticatorName)));
        holder = HttpUtil.makeRequest((HttpClient)httpClient, (HttpMethod)HttpMethod.GET, (String)(baseUrl + "/druid-ext/basic-security/authorization/loadStatus"), null);
        content = holder.getContent();
        loadStatus = (Map)this.jsonMapper.readValue(content, JacksonUtils.TYPE_REFERENCE_MAP_STRING_BOOLEAN);
        String authorizerName = this.getAuthorizerName();
        Assert.assertNotNull(loadStatus.get(authorizerName));
        Assert.assertTrue((boolean)((Boolean)loadStatus.get(authorizerName)));
    }

    protected StatusResponseHolder makeSQLQueryRequest(HttpClient httpClient, String query, HttpResponseStatus expectedStatus) throws Exception {
        return this.makeSQLQueryRequest(httpClient, query, (Map<String, Object>)ImmutableMap.of(), expectedStatus);
    }

    protected StatusResponseHolder makeSQLQueryRequest(HttpClient httpClient, String query, Map<String, Object> context, HttpResponseStatus expectedStatus) throws Exception {
        ImmutableMap queryMap = ImmutableMap.of((Object)"query", (Object)query, (Object)"context", context);
        return HttpUtil.makeRequestWithExpectedStatus((HttpClient)httpClient, (HttpMethod)HttpMethod.POST, (String)(this.config.getBrokerUrl() + "/druid/v2/sql"), (byte[])this.jsonMapper.writeValueAsBytes((Object)queryMap), (HttpResponseStatus)expectedStatus);
    }

    protected void verifySystemSchemaQueryBase(HttpClient client, String query, List<Map<String, Object>> expectedResults, boolean isServerQuery) throws Exception {
        StatusResponseHolder responseHolder = this.makeSQLQueryRequest(client, query, HttpResponseStatus.OK);
        String content = responseHolder.getContent();
        List<Map<String, Object>> responseMap = (List<Map<String, Object>>)this.jsonMapper.readValue(content, SYS_SCHEMA_RESULTS_TYPE_REFERENCE);
        if (isServerQuery) {
            responseMap = AbstractAuthConfigurationTest.getServersWithoutCurrentSize(responseMap);
        }
        Assert.assertEquals(responseMap, expectedResults);
    }

    protected void verifySystemSchemaQuery(HttpClient client, String query, List<Map<String, Object>> expectedResults) throws Exception {
        this.verifySystemSchemaQueryBase(client, query, expectedResults, false);
    }

    protected void verifySystemSchemaServerQuery(HttpClient client, String query, List<Map<String, Object>> expectedResults) throws Exception {
        this.verifySystemSchemaQueryBase(client, query, expectedResults, true);
    }

    protected void verifySystemSchemaQueryFailure(HttpClient client, String query, HttpResponseStatus expectedErrorStatus, String expectedErrorMessage) throws Exception {
        StatusResponseHolder responseHolder = this.makeSQLQueryRequest(client, query, expectedErrorStatus);
        Assert.assertEquals((Object)responseHolder.getStatus(), (Object)expectedErrorStatus);
        Assert.assertEquals((String)responseHolder.getContent(), (String)expectedErrorMessage);
    }

    protected String getBrokerAvacticaUrl() {
        return "jdbc:avatica:remote:url=" + this.config.getBrokerUrl() + "/druid/v2/sql/avatica/";
    }

    protected String getRouterAvacticaUrl() {
        return "jdbc:avatica:remote:url=" + this.config.getRouterUrl() + "/druid/v2/sql/avatica/";
    }

    protected void verifyAdminOptionsRequest() {
        this.testOptionsRequests(this.getHttpClient(User.ADMIN));
    }

    protected void verifyAuthenticationInvalidAuthNameFails() {
        this.verifyInvalidAuthNameFails(StringUtils.format((String)"%s/druid-ext/basic-security/authentication/listen/%s", (Object[])new Object[]{this.config.getCoordinatorUrl(), INVALID_NAME}));
    }

    protected void verifyAuthorizationInvalidAuthNameFails() {
        this.verifyInvalidAuthNameFails(StringUtils.format((String)"%s/druid-ext/basic-security/authorization/listen/users/%s", (Object[])new Object[]{this.config.getCoordinatorUrl(), INVALID_NAME}));
    }

    protected void verifyGroupMappingsInvalidAuthNameFails() {
        this.verifyInvalidAuthNameFails(StringUtils.format((String)"%s/druid-ext/basic-security/authorization/listen/groupMappings/%s", (Object[])new Object[]{this.config.getCoordinatorUrl(), INVALID_NAME}));
    }

    protected void verifyInvalidAuthNameFails(String endpoint) {
        HttpUtil.makeRequestWithExpectedStatus((HttpClient)this.getHttpClient(User.ADMIN), (HttpMethod)HttpMethod.POST, (String)endpoint, (byte[])"SERIALIZED_DATA".getBytes(StandardCharsets.UTF_8), (HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR);
    }

    protected void verifyMaliciousUser() {
        String maliciousUsername = "<script>alert('hello')</script>";
        CredentialedHttpClient maliciousClient = new CredentialedHttpClient((Credentials)new BasicCredentials(maliciousUsername, "noPass"), this.httpClient);
        StatusResponseHolder responseHolder = HttpUtil.makeRequestWithExpectedStatus((HttpClient)maliciousClient, (HttpMethod)HttpMethod.GET, (String)(this.config.getBrokerUrl() + "/status"), null, (HttpResponseStatus)HttpResponseStatus.UNAUTHORIZED);
        String responseContent = responseHolder.getContent();
        Assert.assertTrue((boolean)responseContent.contains("<tr><th>MESSAGE:</th><td>Unauthorized</td></tr>"));
        Assert.assertFalse((boolean)responseContent.contains(maliciousUsername));
    }

    protected void setupHttpClients() throws Exception {
        this.setupCommonHttpClients();
        this.setupTestSpecificHttpClients();
    }

    protected void setupCommonHttpClients() {
        this.httpClients = new HashMap<User, HttpClient>();
        for (User user : User.values()) {
            this.httpClients.put(user, this.setupHttpClientForUser(user.getName(), user.getPassword()));
        }
    }

    protected HttpClient setupHttpClientForUser(String username, String password) {
        return new CredentialedHttpClient((Credentials)new BasicCredentials(username, password), this.httpClient);
    }

    protected void setExpectedSystemSchemaObjects() throws IOException {
        this.adminSegments = (List)this.jsonMapper.readValue(TestQueryHelper.class.getResourceAsStream(SYSTEM_SCHEMA_SEGMENTS_RESULTS_RESOURCE), SYS_SCHEMA_RESULTS_TYPE_REFERENCE);
        this.adminTasks = (List)this.jsonMapper.readValue(TestQueryHelper.class.getResourceAsStream(SYSTEM_SCHEMA_TASKS_RESULTS_RESOURCE), SYS_SCHEMA_RESULTS_TYPE_REFERENCE);
        this.adminServers = AbstractAuthConfigurationTest.getServersWithoutCurrentSize((List)this.jsonMapper.readValue(AbstractAuthConfigurationTest.fillServersTemplate(this.config, AbstractIndexerTest.getResourceAsString(SYSTEM_SCHEMA_SERVERS_RESULTS_RESOURCE)), SYS_SCHEMA_RESULTS_TYPE_REFERENCE));
        this.adminServerSegments = (List)this.jsonMapper.readValue(AbstractAuthConfigurationTest.fillSegementServersTemplate(this.config, AbstractIndexerTest.getResourceAsString(SYSTEM_SCHEMA_SERVER_SEGMENTS_RESULTS_RESOURCE)), SYS_SCHEMA_RESULTS_TYPE_REFERENCE);
    }

    protected static List<Map<String, Object>> getServersWithoutCurrentSize(List<Map<String, Object>> servers) {
        return Lists.transform(servers, server -> {
            HashMap<String, Integer> newServer = new HashMap<String, Integer>((Map<String, Integer>)server);
            newServer.put("curr_size", 0);
            return newServer;
        });
    }

    protected static String fillSegementServersTemplate(IntegrationTestingConfig config, String template) {
        return StringUtils.replace((String)template, (String)"%%HISTORICAL%%", (String)config.getHistoricalInternalHost());
    }

    protected static String fillServersTemplate(IntegrationTestingConfig config, String template) {
        String json = StringUtils.replace((String)template, (String)"%%HISTORICAL%%", (String)config.getHistoricalInternalHost());
        json = StringUtils.replace((String)json, (String)"%%BROKER%%", (String)config.getBrokerInternalHost());
        json = StringUtils.replace((String)json, (String)"%%NON_LEADER%%", (String)String.valueOf(NullHandling.defaultLongValue()));
        return json;
    }

    protected static enum User {
        ADMIN("admin", "priest"),
        DATASOURCE_ONLY_USER("datasourceOnlyUser", "helloworld"),
        DATASOURCE_AND_CONTEXT_PARAMS_USER("datasourceAndContextParamsUser", "helloworld"),
        DATASOURCE_AND_SYS_USER("datasourceAndSysUser", "helloworld"),
        DATASOURCE_WITH_STATE_USER("datasourceWithStateUser", "helloworld"),
        STATE_ONLY_USER("stateOnlyUser", "helloworld"),
        INTERNAL_SYSTEM("druid_system", "warlock");

        private final String name;
        private final String password;

        private User(String name, String password) {
            this.name = name;
            this.password = password;
        }

        public String getName() {
            return this.name;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

