/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.security;

import java.util.List;
import java.util.Properties;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.CredentialedHttpClient;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.auth.BasicCredentials;
import org.apache.druid.java.util.http.client.auth.Credentials;
import org.apache.druid.security.basic.authentication.entity.BasicAuthenticatorCredentialUpdate;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.utils.HttpUtil;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.tests.security.AbstractAuthConfigurationTest;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"security"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITBasicAuthConfigurationTest
extends AbstractAuthConfigurationTest {
    private static final Logger LOG = new Logger(ITBasicAuthConfigurationTest.class);
    private static final String BASIC_AUTHENTICATOR = "basic";
    private static final String BASIC_AUTHORIZER = "basic";
    private static final String EXPECTED_AVATICA_AUTH_ERROR = "Error while executing SQL \"SELECT * FROM INFORMATION_SCHEMA.COLUMNS\": Remote driver error: Unauthorized";
    private static final String EXPECTED_AVATICA_AUTHZ_ERROR = "Error while executing SQL \"SELECT * FROM INFORMATION_SCHEMA.COLUMNS\": Remote driver error: Unauthorized";
    private HttpClient druid99;

    @BeforeClass
    public void before() throws Exception {
        ITRetryUtil.retryUntilTrue(() -> this.coordinatorClient.areSegmentsLoaded("auth_test"), (String)"auth_test segment load");
        this.setupHttpClientsAndUsers();
        this.setExpectedSystemSchemaObjects();
    }

    @Test
    public void test_druid99User_hasNodeAccess() {
        this.checkNodeAccess(this.druid99);
    }

    @Override
    protected void setupDatasourceOnlyUser() throws Exception {
        this.createUserAndRoleWithPermissions(this.getHttpClient(AbstractAuthConfigurationTest.User.ADMIN), "datasourceOnlyUser", "helloworld", "datasourceOnlyRole", DATASOURCE_ONLY_PERMISSIONS);
    }

    @Override
    protected void setupDatasourceAndContextParamsUser() throws Exception {
        this.createUserAndRoleWithPermissions(this.getHttpClient(AbstractAuthConfigurationTest.User.ADMIN), "datasourceAndContextParamsUser", "helloworld", "datasourceAndContextParamsRole", DATASOURCE_QUERY_CONTEXT_PERMISSIONS);
    }

    @Override
    protected void setupDatasourceAndSysTableUser() throws Exception {
        this.createUserAndRoleWithPermissions(this.getHttpClient(AbstractAuthConfigurationTest.User.ADMIN), "datasourceAndSysUser", "helloworld", "datasourceAndSysRole", DATASOURCE_SYS_PERMISSIONS);
    }

    @Override
    protected void setupDatasourceAndSysAndStateUser() throws Exception {
        this.createUserAndRoleWithPermissions(this.getHttpClient(AbstractAuthConfigurationTest.User.ADMIN), "datasourceWithStateUser", "helloworld", "datasourceWithStateRole", DATASOURCE_SYS_STATE_PERMISSIONS);
    }

    @Override
    protected void setupSysTableAndStateOnlyUser() throws Exception {
        this.createUserAndRoleWithPermissions(this.getHttpClient(AbstractAuthConfigurationTest.User.ADMIN), "stateOnlyUser", "helloworld", "stateOnlyRole", STATE_ONLY_PERMISSIONS);
    }

    @Override
    protected void setupTestSpecificHttpClients() throws Exception {
        this.createUserAndRoleWithPermissions(this.getHttpClient(AbstractAuthConfigurationTest.User.ADMIN), "druid", "helloworld", "druidrole", STATE_ONLY_PERMISSIONS);
        for (int i = 0; i < 100; ++i) {
            HttpUtil.makeRequest((HttpClient)this.getHttpClient(AbstractAuthConfigurationTest.User.ADMIN), (HttpMethod)HttpMethod.POST, (String)(this.config.getCoordinatorUrl() + "/druid-ext/basic-security/authentication/db/basic/users/druid" + i), null);
            HttpUtil.makeRequest((HttpClient)this.getHttpClient(AbstractAuthConfigurationTest.User.ADMIN), (HttpMethod)HttpMethod.POST, (String)(this.config.getCoordinatorUrl() + "/druid-ext/basic-security/authorization/db/basic/users/druid" + i), null);
            LOG.info("Finished creating user druid" + i, new Object[0]);
        }
        HttpUtil.makeRequest((HttpClient)this.getHttpClient(AbstractAuthConfigurationTest.User.ADMIN), (HttpMethod)HttpMethod.POST, (String)(this.config.getCoordinatorUrl() + "/druid-ext/basic-security/authentication/db/basic/users/druid99/credentials"), (byte[])this.jsonMapper.writeValueAsBytes((Object)new BasicAuthenticatorCredentialUpdate("helloworld", Integer.valueOf(5000))));
        HttpUtil.makeRequest((HttpClient)this.getHttpClient(AbstractAuthConfigurationTest.User.ADMIN), (HttpMethod)HttpMethod.POST, (String)(this.config.getCoordinatorUrl() + "/druid-ext/basic-security/authorization/db/basic/users/druid99/roles/druidrole"), null);
        this.druid99 = new CredentialedHttpClient((Credentials)new BasicCredentials("druid99", "helloworld"), this.httpClient);
    }

    @Override
    protected String getAuthenticatorName() {
        return "basic";
    }

    @Override
    protected String getAuthorizerName() {
        return "basic";
    }

    @Override
    protected String getExpectedAvaticaAuthError() {
        return "Error while executing SQL \"SELECT * FROM INFORMATION_SCHEMA.COLUMNS\": Remote driver error: Unauthorized";
    }

    @Override
    protected String getExpectedAvaticaAuthzError() {
        return "Error while executing SQL \"SELECT * FROM INFORMATION_SCHEMA.COLUMNS\": Remote driver error: Unauthorized";
    }

    @Override
    protected Properties getAvaticaConnectionPropertiesForInvalidAdmin() {
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("user", "admin");
        connectionProperties.setProperty("password", "invalid_password");
        return connectionProperties;
    }

    @Override
    protected Properties getAvaticaConnectionPropertiesForUser(AbstractAuthConfigurationTest.User user) {
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("user", user.getName());
        connectionProperties.setProperty("password", user.getPassword());
        return connectionProperties;
    }

    private void createUserAndRoleWithPermissions(HttpClient adminClient, String user, String password, String role, List<ResourceAction> permissions) throws Exception {
        HttpUtil.makeRequest((HttpClient)adminClient, (HttpMethod)HttpMethod.POST, (String)StringUtils.format((String)"%s/druid-ext/basic-security/authentication/db/basic/users/%s", (Object[])new Object[]{this.config.getCoordinatorUrl(), user}), null);
        HttpUtil.makeRequest((HttpClient)adminClient, (HttpMethod)HttpMethod.POST, (String)StringUtils.format((String)"%s/druid-ext/basic-security/authentication/db/basic/users/%s/credentials", (Object[])new Object[]{this.config.getCoordinatorUrl(), user}), (byte[])this.jsonMapper.writeValueAsBytes((Object)new BasicAuthenticatorCredentialUpdate(password, Integer.valueOf(5000))));
        HttpUtil.makeRequest((HttpClient)adminClient, (HttpMethod)HttpMethod.POST, (String)StringUtils.format((String)"%s/druid-ext/basic-security/authorization/db/basic/users/%s", (Object[])new Object[]{this.config.getCoordinatorUrl(), user}), null);
        HttpUtil.makeRequest((HttpClient)adminClient, (HttpMethod)HttpMethod.POST, (String)StringUtils.format((String)"%s/druid-ext/basic-security/authorization/db/basic/roles/%s", (Object[])new Object[]{this.config.getCoordinatorUrl(), role}), null);
        HttpUtil.makeRequest((HttpClient)adminClient, (HttpMethod)HttpMethod.POST, (String)StringUtils.format((String)"%s/druid-ext/basic-security/authorization/db/basic/users/%s/roles/%s", (Object[])new Object[]{this.config.getCoordinatorUrl(), user, role}), null);
        byte[] permissionsBytes = this.jsonMapper.writeValueAsBytes(permissions);
        HttpUtil.makeRequest((HttpClient)adminClient, (HttpMethod)HttpMethod.POST, (String)StringUtils.format((String)"%s/druid-ext/basic-security/authorization/db/basic/roles/%s/permissions", (Object[])new Object[]{this.config.getCoordinatorUrl(), role}), (byte[])permissionsBytes);
    }
}

