/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.tests.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.CredentialedHttpClient;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.auth.BasicCredentials;
import org.apache.druid.java.util.http.client.auth.Credentials;
import org.apache.druid.security.basic.authorization.entity.BasicAuthorizerGroupMapping;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.guice.DruidTestModuleFactory;
import org.apache.druid.testing.utils.HttpUtil;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.tests.security.AbstractAuthConfigurationTest;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Guice;
import org.testng.annotations.Test;

@Test(groups={"ldap-security"})
@Guice(moduleFactory=DruidTestModuleFactory.class)
public class ITBasicAuthLdapConfigurationTest
extends AbstractAuthConfigurationTest {
    private static final Logger LOG = new Logger(ITBasicAuthLdapConfigurationTest.class);
    private static final String LDAP_AUTHENTICATOR = "ldap";
    private static final String LDAP_AUTHORIZER = "ldapauth";
    private static final String EXPECTED_AVATICA_AUTH_ERROR = "Error while executing SQL \"SELECT * FROM INFORMATION_SCHEMA.COLUMNS\": Remote driver error: Unauthorized";
    private static final String EXPECTED_AVATICA_AUTHZ_ERROR = "Error while executing SQL \"SELECT * FROM INFORMATION_SCHEMA.COLUMNS\": Remote driver error: Unauthorized";
    @Inject
    IntegrationTestingConfig config;
    @Inject
    ObjectMapper jsonMapper;
    private HttpClient druidUserClient;
    private HttpClient stateOnlyNoLdapGroupUserClient;

    @BeforeClass
    public void before() throws Exception {
        ITRetryUtil.retryUntilTrue(() -> this.coordinatorClient.areSegmentsLoaded("auth_test"), (String)"auth_test segment load");
        this.setupHttpClientsAndUsers();
        this.setExpectedSystemSchemaObjects();
    }

    @Test
    public void test_systemSchemaAccess_stateOnlyNoLdapGroupUser() throws Exception {
        HttpUtil.makeRequest((HttpClient)this.getHttpClient(AbstractAuthConfigurationTest.User.STATE_ONLY_USER), (HttpMethod)HttpMethod.GET, (String)(this.config.getBrokerUrl() + "/status"), null);
        LOG.info("Checking sys.segments query as stateOnlyNoLdapGroupUser...", new Object[0]);
        this.verifySystemSchemaQuery(this.stateOnlyNoLdapGroupUserClient, "SELECT * FROM sys.segments WHERE datasource IN ('auth_test')", Collections.emptyList());
        LOG.info("Checking sys.servers query as stateOnlyNoLdapGroupUser...", new Object[0]);
        this.verifySystemSchemaServerQuery(this.stateOnlyNoLdapGroupUserClient, "SELECT * FROM sys.servers WHERE tier IS NOT NULL", this.adminServers);
        LOG.info("Checking sys.server_segments query as stateOnlyNoLdapGroupUser...", new Object[0]);
        this.verifySystemSchemaQuery(this.stateOnlyNoLdapGroupUserClient, "SELECT * FROM sys.server_segments WHERE segment_id LIKE 'auth_test%'", Collections.emptyList());
        LOG.info("Checking sys.tasks query as stateOnlyNoLdapGroupUser...", new Object[0]);
        this.verifySystemSchemaQuery(this.stateOnlyNoLdapGroupUserClient, "SELECT * FROM sys.tasks WHERE datasource IN ('auth_test')", Collections.emptyList());
    }

    @Test
    public void test_druidUser_hasNodeAccess() {
        this.checkNodeAccess(this.druidUserClient);
    }

    @Override
    protected void setupDatasourceOnlyUser() throws Exception {
        this.createRoleWithPermissionsAndGroupMapping("datasourceOnlyGroup", (Map<String, List<ResourceAction>>)ImmutableMap.of((Object)"datasourceOnlyRole", (Object)DATASOURCE_ONLY_PERMISSIONS));
    }

    @Override
    protected void setupDatasourceAndContextParamsUser() throws Exception {
        this.createRoleWithPermissionsAndGroupMapping("datasourceAndContextParamsGroup", (Map<String, List<ResourceAction>>)ImmutableMap.of((Object)"datasourceAndContextParamsRole", (Object)DATASOURCE_QUERY_CONTEXT_PERMISSIONS));
    }

    @Override
    protected void setupDatasourceAndSysTableUser() throws Exception {
        this.createRoleWithPermissionsAndGroupMapping("datasourceWithSysGroup", (Map<String, List<ResourceAction>>)ImmutableMap.of((Object)"datasourceWithSysRole", (Object)DATASOURCE_SYS_PERMISSIONS));
    }

    @Override
    protected void setupDatasourceAndSysAndStateUser() throws Exception {
        this.createRoleWithPermissionsAndGroupMapping("datasourceWithStateGroup", (Map<String, List<ResourceAction>>)ImmutableMap.of((Object)"datasourceWithStateRole", (Object)DATASOURCE_SYS_STATE_PERMISSIONS));
    }

    @Override
    protected void setupSysTableAndStateOnlyUser() throws Exception {
        this.createRoleWithPermissionsAndGroupMapping("stateOnlyGroup", (Map<String, List<ResourceAction>>)ImmutableMap.of((Object)"stateOnlyRole", (Object)STATE_ONLY_PERMISSIONS));
        this.createRoleWithPermissionsAndGroupMapping("druidGroup", (Map<String, List<ResourceAction>>)ImmutableMap.of((Object)"druidrole", (Object)STATE_ONLY_PERMISSIONS));
        this.assignUserToRole("stateOnlyNoLdapGroup", "stateOnlyRole");
    }

    @Override
    protected void setupTestSpecificHttpClients() {
        this.druidUserClient = new CredentialedHttpClient((Credentials)new BasicCredentials("druid", "helloworld"), this.httpClient);
        this.stateOnlyNoLdapGroupUserClient = new CredentialedHttpClient((Credentials)new BasicCredentials("stateOnlyNoLdapGroup", "helloworld"), this.httpClient);
    }

    @Override
    protected String getAuthenticatorName() {
        return LDAP_AUTHENTICATOR;
    }

    @Override
    protected String getAuthorizerName() {
        return LDAP_AUTHORIZER;
    }

    @Override
    protected String getExpectedAvaticaAuthError() {
        return "Error while executing SQL \"SELECT * FROM INFORMATION_SCHEMA.COLUMNS\": Remote driver error: Unauthorized";
    }

    @Override
    protected String getExpectedAvaticaAuthzError() {
        return "Error while executing SQL \"SELECT * FROM INFORMATION_SCHEMA.COLUMNS\": Remote driver error: Unauthorized";
    }

    @Override
    protected Properties getAvaticaConnectionPropertiesForInvalidAdmin() {
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("user", "admin");
        connectionProperties.setProperty("password", "invalid_password");
        return connectionProperties;
    }

    @Override
    protected Properties getAvaticaConnectionPropertiesForUser(AbstractAuthConfigurationTest.User user) {
        Properties connectionProperties = new Properties();
        connectionProperties.setProperty("user", user.getName());
        connectionProperties.setProperty("password", user.getPassword());
        return connectionProperties;
    }

    private void createRoleWithPermissionsAndGroupMapping(String group, Map<String, List<ResourceAction>> roleTopermissions) throws Exception {
        HttpClient adminClient = this.getHttpClient(AbstractAuthConfigurationTest.User.ADMIN);
        roleTopermissions.keySet().forEach(role -> HttpUtil.makeRequest((HttpClient)adminClient, (HttpMethod)HttpMethod.POST, (String)StringUtils.format((String)"%s/druid-ext/basic-security/authorization/db/ldapauth/roles/%s", (Object[])new Object[]{this.config.getCoordinatorUrl(), role}), null));
        for (Map.Entry<String, List<ResourceAction>> entry : roleTopermissions.entrySet()) {
            String role2 = entry.getKey();
            List<ResourceAction> permissions = entry.getValue();
            byte[] permissionsBytes = this.jsonMapper.writeValueAsBytes(permissions);
            HttpUtil.makeRequest((HttpClient)adminClient, (HttpMethod)HttpMethod.POST, (String)StringUtils.format((String)"%s/druid-ext/basic-security/authorization/db/ldapauth/roles/%s/permissions", (Object[])new Object[]{this.config.getCoordinatorUrl(), role2}), (byte[])permissionsBytes);
        }
        String groupMappingName = StringUtils.format((String)"%sMapping", (Object[])new Object[]{group});
        BasicAuthorizerGroupMapping groupMapping = new BasicAuthorizerGroupMapping(groupMappingName, StringUtils.format((String)"cn=%s,ou=Groups,dc=example,dc=org", (Object[])new Object[]{group}), roleTopermissions.keySet());
        byte[] groupMappingBytes = this.jsonMapper.writeValueAsBytes((Object)groupMapping);
        HttpUtil.makeRequest((HttpClient)adminClient, (HttpMethod)HttpMethod.POST, (String)StringUtils.format((String)"%s/druid-ext/basic-security/authorization/db/ldapauth/groupMappings/%s", (Object[])new Object[]{this.config.getCoordinatorUrl(), groupMappingName}), (byte[])groupMappingBytes);
    }

    private void assignUserToRole(String user, String role) {
        HttpClient adminClient = this.getHttpClient(AbstractAuthConfigurationTest.User.ADMIN);
        HttpUtil.makeRequest((HttpClient)adminClient, (HttpMethod)HttpMethod.POST, (String)StringUtils.format((String)"%s/druid-ext/basic-security/authorization/db/ldapauth/users/%s", (Object[])new Object[]{this.config.getCoordinatorUrl(), user}), null);
        HttpUtil.makeRequest((HttpClient)adminClient, (HttpMethod)HttpMethod.POST, (String)StringUtils.format((String)"%s/druid-ext/basic-security/authorization/db/ldapauth/users/%s/roles/%s", (Object[])new Object[]{this.config.getCoordinatorUrl(), user, role}), null);
    }
}

