/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.druid.indexer.TaskState;
import org.apache.druid.indexer.TaskStatusPlus;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.msq.indexing.report.MSQResultsReport;
import org.apache.druid.msq.indexing.report.MSQTaskReport;
import org.apache.druid.msq.indexing.report.MSQTaskReportPayload;
import org.apache.druid.msq.sql.SqlTaskStatus;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.http.SqlQuery;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.clients.SqlResourceTestClient;
import org.apache.druid.testing.clients.msq.MsqOverlordResourceTestClient;
import org.apache.druid.testing.utils.AbstractTestQueryHelper;
import org.apache.druid.testing.utils.MsqQueryWithResults;
import org.apache.druid.testing.utils.QueryResultVerifier;
import org.apache.druid.testing.utils.TestQueryHelper;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.testng.Assert;

public class MsqTestQueryHelper
extends AbstractTestQueryHelper<MsqQueryWithResults> {
    private final ObjectMapper jsonMapper;
    private final IntegrationTestingConfig config;
    private final MsqOverlordResourceTestClient overlordClient;
    private final SqlResourceTestClient msqClient;

    @Inject
    MsqTestQueryHelper(ObjectMapper jsonMapper, SqlResourceTestClient queryClient, IntegrationTestingConfig config, MsqOverlordResourceTestClient overlordClient, SqlResourceTestClient msqClient) {
        super(jsonMapper, queryClient, config);
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.overlordClient = overlordClient;
        this.msqClient = msqClient;
    }

    @Override
    public String getQueryURL(String schemeAndHost) {
        return StringUtils.format((String)"%s/druid/v2/sql/task", (Object[])new Object[]{schemeAndHost});
    }

    public SqlTaskStatus submitMsqTask(String sqlQueryString) throws ExecutionException, InterruptedException {
        return this.submitMsqTask(sqlQueryString, (Map<String, Object>)ImmutableMap.of());
    }

    public SqlTaskStatus submitMsqTask(String sqlQueryString, Map<String, Object> context) throws ExecutionException, InterruptedException {
        return this.submitMsqTask(new SqlQuery(sqlQueryString, null, false, false, false, context, null));
    }

    public SqlTaskStatus submitMsqTask(SqlQuery sqlQuery) throws ExecutionException, InterruptedException {
        SqlTaskStatus sqlTaskStatus;
        StatusResponseHolder statusResponseHolder;
        String queryUrl = this.getQueryURL(this.config.getBrokerUrl());
        Future<StatusResponseHolder> responseHolderFuture = this.msqClient.queryAsync(queryUrl, sqlQuery);
        try {
            statusResponseHolder = responseHolderFuture.get(5L, TimeUnit.MINUTES);
        }
        catch (TimeoutException e) {
            throw new ISE((Throwable)e, "Unable to fetch the task id for the submitted task in time.", new Object[0]);
        }
        HttpResponseStatus httpResponseStatus = statusResponseHolder.getStatus();
        if (!httpResponseStatus.equals((Object)HttpResponseStatus.ACCEPTED)) {
            throw new ISE("Unable to submit the task successfully. Received response status code [%d], and response content:\n[%s]", new Object[]{httpResponseStatus, statusResponseHolder.getContent()});
        }
        String content = statusResponseHolder.getContent();
        try {
            sqlTaskStatus = (SqlTaskStatus)this.jsonMapper.readValue(content, SqlTaskStatus.class);
        }
        catch (JsonProcessingException e) {
            throw new ISE("Unable to parse the response", new Object[0]);
        }
        return sqlTaskStatus;
    }

    public TaskState pollTaskIdForCompletion(String taskId) throws Exception {
        return (TaskState)RetryUtils.retry(() -> {
            TaskStatusPlus taskStatusPlus = this.overlordClient.getTaskStatus(taskId);
            TaskState statusCode = taskStatusPlus.getStatusCode();
            if (statusCode != null && statusCode.isComplete()) {
                return taskStatusPlus.getStatusCode();
            }
            throw new TaskStillRunningException();
        }, t -> t instanceof TaskStillRunningException, (int)99, (int)100);
    }

    public Map<String, MSQTaskReport> fetchStatusReports(String taskId) {
        return this.overlordClient.getMsqTaskReport(taskId);
    }

    private void compareResults(String taskId, MsqQueryWithResults expectedQueryWithResults) {
        Map<String, MSQTaskReport> statusReport = this.fetchStatusReports(taskId);
        MSQTaskReport taskReport = statusReport.get("multiStageQuery");
        if (taskReport == null) {
            throw new ISE("Unable to fetch the status report for the task [%]", new Object[]{taskId});
        }
        MSQTaskReportPayload taskReportPayload = (MSQTaskReportPayload)Preconditions.checkNotNull((Object)taskReport.getPayload(), (Object)"payload");
        MSQResultsReport resultsReport = (MSQResultsReport)Preconditions.checkNotNull((Object)taskReportPayload.getResults(), (Object)"Results report for the task id is empty");
        ArrayList<Map<String, Object>> actualResults = new ArrayList<Map<String, Object>>();
        Yielder yielder = resultsReport.getResultYielder();
        RowSignature rowSignature = resultsReport.getSignature();
        while (!yielder.isDone()) {
            Object[] row = (Object[])yielder.get();
            LinkedHashMap<String, Object> rowWithFieldNames = new LinkedHashMap<String, Object>();
            for (int i = 0; i < row.length; ++i) {
                rowWithFieldNames.put(rowSignature.getColumnName(i), row[i]);
            }
            actualResults.add(rowWithFieldNames);
            yielder = yielder.next(null);
        }
        QueryResultVerifier.ResultVerificationObject resultsComparison = QueryResultVerifier.compareResults(actualResults, expectedQueryWithResults.getExpectedResults(), Collections.emptyList());
        if (!resultsComparison.isSuccess()) {
            throw new IAE("Expected query result is different from the actual result.\nQuery: %s\nActual Result: %s\nExpected Result: %s\nMismatch Error: %s\n", new Object[]{expectedQueryWithResults.getQuery(), actualResults, expectedQueryWithResults.getExpectedResults(), resultsComparison.getErrorMessage()});
        }
    }

    @Override
    public void testQueriesFromFile(String filePath, String fullDatasourcePath) throws Exception {
        LOG.info("Starting query tests for [%s]", new Object[]{filePath});
        List queries = (List)this.jsonMapper.readValue(TestQueryHelper.class.getResourceAsStream(filePath), (TypeReference)new TypeReference<List<MsqQueryWithResults>>(){});
        for (MsqQueryWithResults queryWithResults : queries) {
            String queryString = (String)queryWithResults.getQuery();
            String queryWithDatasource = StringUtils.replace((String)queryString, (String)"%%DATASOURCE%%", (String)fullDatasourcePath);
            SqlTaskStatus sqlTaskStatus = this.submitMsqTask(queryWithDatasource);
            if (sqlTaskStatus.getState().isFailure()) {
                throw new ISE("Unable to start the task successfully.\nPossible exception: %s", new Object[]{sqlTaskStatus.getError()});
            }
            String taskId = sqlTaskStatus.getTaskId();
            this.pollTaskIdForCompletion(taskId);
            this.compareResults(taskId, queryWithResults);
        }
    }

    public void submitMsqTaskAndWaitForCompletion(String sqlQueryString, Map<String, Object> context) throws Exception {
        SqlTaskStatus sqlTaskStatus = this.submitMsqTask(sqlQueryString, context);
        LOG.info("Sql Task submitted with task Id - %s", new Object[]{sqlTaskStatus.getTaskId()});
        if (sqlTaskStatus.getState().isFailure()) {
            Assert.fail((String)StringUtils.format((String)"Unable to start the task successfully.\nPossible exception: %s", (Object[])new Object[]{sqlTaskStatus.getError()}));
        }
        this.pollTaskIdForCompletion(sqlTaskStatus.getTaskId());
    }

    private static class TaskStillRunningException
    extends Exception {
        private TaskStillRunningException() {
        }
    }
}

