/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import java.util.List;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.testing.utils.EventSerializer;
import org.apache.druid.testing.utils.StreamEventWriter;
import org.apache.druid.testing.utils.StreamGenerator;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public abstract class SyntheticStreamGenerator
implements StreamGenerator {
    private static final Logger LOG = new Logger(SyntheticStreamGenerator.class);
    private final EventSerializer serializer;
    private final int eventsPerSecond;
    private final long cyclePaddingMs;

    public SyntheticStreamGenerator(EventSerializer serializer, int eventsPerSecond, long cyclePaddingMs) {
        this.serializer = serializer;
        this.eventsPerSecond = eventsPerSecond;
        this.cyclePaddingMs = cyclePaddingMs;
    }

    abstract List<Pair<String, Object>> newEvent(int var1, DateTime var2);

    @Override
    public long run(String streamTopic, StreamEventWriter streamEventWriter, int totalNumberOfSeconds) {
        return this.run(streamTopic, streamEventWriter, totalNumberOfSeconds, null);
    }

    @Override
    public long run(String streamTopic, StreamEventWriter streamEventWriter, int totalNumberOfSeconds, DateTime overrrideFirstEventTime) {
        this.serializer.initialize(streamTopic);
        DateTime nowCeilingToSecond = DateTimes.nowUtc().secondOfDay().roundCeilingCopy();
        DateTime eventTimestamp = overrrideFirstEventTime == null ? nowCeilingToSecond : overrrideFirstEventTime;
        int seconds = 0;
        long numWritten = 0L;
        try {
            while (true) {
                long sleepMillis;
                if ((sleepMillis = nowCeilingToSecond.getMillis() - DateTimes.nowUtc().getMillis()) > 0L) {
                    LOG.info("Waiting %s ms for next run cycle (at %s)", new Object[]{sleepMillis, nowCeilingToSecond});
                    Thread.sleep(sleepMillis);
                    continue;
                }
                LOG.info("Beginning run cycle with %s events, target completion time: %s", new Object[]{this.eventsPerSecond, nowCeilingToSecond.plusSeconds(1).minus(this.cyclePaddingMs)});
                if (streamEventWriter.supportTransaction() && streamEventWriter.isTransactionEnabled()) {
                    streamEventWriter.initTransaction();
                }
                for (int i = 1; i <= this.eventsPerSecond; ++i) {
                    streamEventWriter.write(streamTopic, this.serializer.serialize(this.newEvent(i, eventTimestamp)));
                    ++numWritten;
                    long sleepTime = this.calculateSleepTimeMs(this.eventsPerSecond - i, nowCeilingToSecond);
                    if (i <= 100 && i % 10 == 0 || i % 100 == 0) {
                        LOG.info("Event: %s/%s, sleep time: %s ms", new Object[]{i, this.eventsPerSecond, sleepTime});
                    }
                    if (sleepTime <= 0L) continue;
                    Thread.sleep(sleepTime);
                }
                if (streamEventWriter.supportTransaction() && streamEventWriter.isTransactionEnabled()) {
                    streamEventWriter.commitTransaction();
                }
                nowCeilingToSecond = nowCeilingToSecond.plusSeconds(1);
                eventTimestamp = eventTimestamp.plusSeconds(1);
                LOG.info("Finished writing %s events, current time: %s - updating next timestamp to: %s", new Object[]{this.eventsPerSecond, DateTimes.nowUtc(), nowCeilingToSecond});
                if (++seconds >= totalNumberOfSeconds) break;
            }
            streamEventWriter.flush();
            LOG.info("Finished writing %s seconds", new Object[]{seconds});
        }
        catch (Exception e) {
            throw new RuntimeException("Exception in event generation loop", e);
        }
        return numWritten;
    }

    private long calculateSleepTimeMs(long eventsRemaining, DateTime secondBeingProcessed) {
        if (eventsRemaining == 0L) {
            return 0L;
        }
        DateTime now = DateTimes.nowUtc();
        DateTime nextSecondToProcessMinusBuffer = secondBeingProcessed.plusSeconds(1).minus(this.cyclePaddingMs);
        if (nextSecondToProcessMinusBuffer.isBefore((ReadableInstant)now)) {
            return 0L;
        }
        return (nextSecondToProcessMinusBuffer.getMillis() - now.getMillis()) / eventsRemaining;
    }
}

