{
  "type": "index_hadoop",
  "hadoopDependencyCoordinates" : ["org.apache.hadoop:hadoop-client-api:3.3.6", "org.apache.hadoop:hadoop-client-runtime:3.3.6", "org.apache.hadoop:hadoop-azure:3.3.6"],
  "spec": {
    "dataSchema": {
      "dataSource": "%%DATASOURCE%%",
      "parser": {
        "type": "hadoopyString",
        "parseSpec": {
          "format" : "json",
          "timestampSpec": {
            "column": "timestamp"
          },
          "dimensionsSpec": {
            "dimensions": [
              "page",
              {"type": "string", "name": "language", "createBitmapIndex": false},
              "user",
              "unpatrolled",
              "newPage",
              "robot",
              "anonymous",
              "namespace",
              "continent",
              "country",
              "region",
              "city"
            ]
          }
        }
      },
      "metricsSpec": [
        {
          "type": "count",
          "name": "count"
        },
        {
          "type": "doubleSum",
          "name": "added",
          "fieldName": "added"
        },
        {
          "type": "doubleSum",
          "name": "deleted",
          "fieldName": "deleted"
        },
        {
          "type": "doubleSum",
          "name": "delta",
          "fieldName": "delta"
        },
        {
          "name": "thetaSketch",
          "type": "thetaSketch",
          "fieldName": "user"
        },
        {
          "name": "quantilesDoublesSketch",
          "type": "quantilesDoublesSketch",
          "fieldName": "delta"
        },
        {
          "name": "HLLSketchBuild",
          "type": "HLLSketchBuild",
          "fieldName": "user"
        }
      ],
      "granularitySpec": {
        "segmentGranularity": "DAY",
        "queryGranularity": "second",
        "intervals" : [ "2013-08-31/2013-09-02" ]
      }
    },
    "ioConfig": {
      "type": "hadoop",
      "inputSpec": {
        "type": "static",
        "paths": "%%INPUT_PATHS%%"
      }
    },
    "tuningConfig": {
      "type": "hadoop",
      "partitionsSpec": {
        "assumeGrouped": true,
        "targetPartitionSize": 75000,
        "type": "hashed"
      },
      "jobProperties": {
        "fs.permissions.umask-mode": "022",
        "fs.default.name" : "hdfs://druid-it-hadoop:9000",
        "fs.defaultFS" : "hdfs://druid-it-hadoop:9000",
        "dfs.datanode.address" : "druid-it-hadoop",
        "dfs.client.use.datanode.hostname" : "true",
        "dfs.datanode.use.datanode.hostname" : "true",
        "yarn.resourcemanager.hostname" : "druid-it-hadoop",
        "yarn.nodemanager.vmem-check-enabled" : "false",
        "mapreduce.map.java.opts" : "-Duser.timezone=UTC -Dfile.encoding=UTF-8",
        "mapreduce.job.classloader": "true",
        "mapreduce.job.user.classpath.first" : "true",
        "mapreduce.reduce.java.opts" : "-Duser.timezone=UTC -Dfile.encoding=UTF-8",
        "mapreduce.map.memory.mb" : 1024,
        "mapreduce.reduce.memory.mb" : 1024,
        "fs.azure.account.key.%%AZURE_ACCOUNT%%.blob.core.windows.net":"%%AZURE_KEY%%"
      },
      "rowFlushBoundary": 10000
    }
  }
}