/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.clients.msq;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import java.util.Map;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.msq.guice.MSQIndexingModule;
import org.apache.druid.msq.indexing.report.MSQTaskReport;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.clients.OverlordResourceTestClient;
import org.apache.druid.testing.guice.TestClient;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class MsqOverlordResourceTestClient
extends OverlordResourceTestClient {
    private ObjectMapper jsonMapper;

    @Inject
    MsqOverlordResourceTestClient(@Json ObjectMapper jsonMapper, @TestClient HttpClient httpClient, IntegrationTestingConfig config) {
        super(jsonMapper, httpClient, config);
        this.jsonMapper = jsonMapper;
        this.jsonMapper.registerModules((Iterable)new MSQIndexingModule().getJacksonModules());
    }

    public Map<String, MSQTaskReport> getMsqTaskReport(String taskId) {
        try {
            StatusResponseHolder response = this.makeRequest(HttpMethod.GET, StringUtils.format((String)"%s%s", (Object[])new Object[]{this.getIndexerURL(), StringUtils.format((String)"task/%s/reports", (Object[])new Object[]{StringUtils.urlEncode((String)taskId)})}));
            return (Map)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Map<String, MSQTaskReport>>(){});
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

