/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;

public class ITRetryUtil {
    private static final Logger LOG = new Logger(ITRetryUtil.class);
    public static final int DEFAULT_RETRY_COUNT = 240;
    public static final long DEFAULT_RETRY_SLEEP = TimeUnit.SECONDS.toMillis(5L);

    public static void retryUntilTrue(Callable<Boolean> callable, String task) {
        ITRetryUtil.retryUntil(callable, true, DEFAULT_RETRY_SLEEP, 240, task);
    }

    public static void retryUntilFalse(Callable<Boolean> callable, String task) {
        ITRetryUtil.retryUntil(callable, false, DEFAULT_RETRY_SLEEP, 240, task);
    }

    public static void retryUntil(Callable<Boolean> callable, boolean expectedValue, long delayInMillis, int retryCount, String taskMessage) {
        int currentTry = 0;
        Exception lastException = null;
        while (true) {
            try {
                LOG.info("Trying attempt[%d/%d]...", new Object[]{currentTry, retryCount});
                if (currentTry > retryCount || callable.call() == expectedValue) {
                    break;
                }
            }
            catch (Exception e) {
                lastException = e;
            }
            LOG.info("Attempt[%d/%d] did not pass: Task %s still not complete. Next retry in %d ms", new Object[]{currentTry, retryCount, taskMessage, delayInMillis});
            try {
                Thread.sleep(delayInMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++currentTry;
        }
        if (currentTry > retryCount) {
            if (lastException != null) {
                throw new ISE("Max number of retries[%d] exceeded for Task[%s]. Failing.", new Object[]{retryCount, taskMessage, lastException});
            }
            throw new ISE("Max number of retries[%d] exceeded for Task[%s]. Failing.", new Object[]{retryCount, taskMessage});
        }
    }
}

