/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.RetryUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.testing.IntegrationTestingConfig;
import org.apache.druid.testing.utils.ProtobufEventSerializer;

public class ProtobufSchemaRegistryEventSerializer
extends ProtobufEventSerializer {
    private static final int MAX_INITIALIZE_RETRIES = 10;
    public static final String TYPE = "protobuf-schema-registry";
    private final IntegrationTestingConfig config;
    private final CachedSchemaRegistryClient client;
    private int schemaId = -1;

    @JsonCreator
    public ProtobufSchemaRegistryEventSerializer(@JacksonInject IntegrationTestingConfig config) {
        this.config = config;
        this.client = new CachedSchemaRegistryClient(StringUtils.format((String)"http://%s", (Object[])new Object[]{config.getSchemaRegistryHost()}), Integer.MAX_VALUE, (Map)ImmutableMap.of((Object)"basic.auth.credentials.source", (Object)"USER_INFO", (Object)"basic.auth.user.info", (Object)"druid:diurd"), (Map)ImmutableMap.of());
    }

    @Override
    public void initialize(String topic) {
        try {
            RetryUtils.retry(() -> {
                this.schemaId = this.client.register(topic, (ParsedSchema)new ProtobufSchema(ProtobufEventSerializer.SCHEMA.newMessageBuilder("Wikipedia").getDescriptorForType()));
                return 0;
            }, e -> true, (int)10);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public byte[] serialize(List<Pair<String, Object>> event) {
        DynamicMessage.Builder builder = SCHEMA.newMessageBuilder("Wikipedia");
        Descriptors.Descriptor msgDesc = builder.getDescriptorForType();
        for (Pair<String, Object> pair : event) {
            builder.setField(msgDesc.findFieldByName((String)pair.lhs), pair.rhs);
        }
        byte[] bytes = builder.build().toByteArray();
        ByteBuffer bb = ByteBuffer.allocate(bytes.length + 6).put((byte)0).putInt(this.schemaId).put((byte)0).put(bytes);
        bb.rewind();
        return bb.array();
    }
}

