/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;

public class QueryResultVerifier {
    public static ResultVerificationObject compareResults(Iterable<Map<String, Object>> actual, Iterable<Map<String, Object>> expected, List<String> fieldsToTest) {
        Iterator<Map<String, Object>> actualIter = actual.iterator();
        Iterator<Map<String, Object>> expectedIter = expected.iterator();
        int rowNumber = 1;
        while (actualIter.hasNext() && expectedIter.hasNext()) {
            Map<String, Object> actualRes = actualIter.next();
            Map<String, Object> expRes = expectedIter.next();
            if (fieldsToTest != null && !fieldsToTest.isEmpty()) {
                for (String field : fieldsToTest) {
                    if (actualRes.get(field).equals(expRes.get(field))) continue;
                    String mismatchMessage = StringUtils.format((String)"Mismatch in row no. [%d], column [%s]. Expected: [%s], Actual: [%s]", (Object[])new Object[]{rowNumber, field, expRes, actualRes});
                    return new ResultVerificationObject(mismatchMessage);
                }
            } else if (!actualRes.equals(expRes)) {
                String mismatchMessage = StringUtils.format((String)"Mismatch in row no. [%d]. Expected: [%s], Actual: [%s]", (Object[])new Object[]{rowNumber, expRes, actualRes});
                return new ResultVerificationObject(mismatchMessage);
            }
            ++rowNumber;
        }
        if (actualIter.hasNext() || expectedIter.hasNext()) {
            String mismatchMessage = StringUtils.format((String)"Results size mismatch. The actual result contain %s rows than the expected result.", (Object[])new Object[]{actualIter.hasNext() ? "more" : "less"});
            return new ResultVerificationObject(mismatchMessage);
        }
        return new ResultVerificationObject(null);
    }

    public static class ResultVerificationObject {
        @Nullable
        private final String errorMessage;

        ResultVerificationObject(@Nullable String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public boolean isSuccess() {
            return this.getErrorMessage() == null;
        }

        @Nullable
        public String getErrorMessage() {
            return this.errorMessage;
        }
    }
}

