/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import java.util.Arrays;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;

public class LoggerListener
extends TestListenerAdapter {
    private static final Logger LOG = new Logger(LoggerListener.class);

    public void onTestFailure(ITestResult tr) {
        LOG.error(tr.getThrowable(), "Failed %s", new Object[]{LoggerListener.formatTestName(tr)});
    }

    public void onTestSkipped(ITestResult tr) {
        LOG.warn("Skipped %s", new Object[]{LoggerListener.formatTestName(tr)});
    }

    public void onTestSuccess(ITestResult tr) {
        LOG.info("Passed %s", new Object[]{LoggerListener.formatTestName(tr)});
    }

    public void onTestStart(ITestResult tr) {
        LOG.info("Starting %s", new Object[]{LoggerListener.formatTestName(tr)});
    }

    private static String formatTestName(ITestResult tr) {
        if (tr.getParameters().length == 0) {
            return StringUtils.format((String)"[%s.%s]", (Object[])new Object[]{tr.getTestClass().getName(), tr.getName()});
        }
        return StringUtils.format((String)"[%s.%s] with parameters %s", (Object[])new Object[]{tr.getTestClass().getName(), tr.getName(), Arrays.toString(tr.getParameters())});
    }
}

