/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.clients;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHandler;
import org.apache.druid.java.util.http.client.response.BytesFullResponseHolder;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHandler;
import org.apache.druid.java.util.http.client.response.StatusResponseHolder;
import org.apache.druid.testing.guice.TestClient;
import org.apache.druid.testing.utils.ITRetryUtil;
import org.apache.druid.utils.Throwables;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public abstract class AbstractQueryResourceTestClient<QueryType> {
    private static final Logger LOG = new Logger(AbstractQueryResourceTestClient.class);
    final String contentTypeHeader;
    final String acceptHeader;
    final ObjectMapper jsonMapper;
    final ObjectMapper smileMapper;
    final HttpClient httpClient;
    final String routerUrl;
    final Map<String, EncoderDecoder> encoderDecoderMap;

    @Inject
    AbstractQueryResourceTestClient(ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, @TestClient HttpClient httpClient, String routerUrl, String contentTypeHeader, @Nullable String acceptHeader) {
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.httpClient = httpClient;
        this.routerUrl = routerUrl;
        this.encoderDecoderMap = new HashMap<String, EncoderDecoder>();
        this.encoderDecoderMap.put("application/json", new ObjectMapperEncoderDecoder(jsonMapper));
        this.encoderDecoderMap.put("application/x-jackson-smile", new ObjectMapperEncoderDecoder(smileMapper));
        if (!this.encoderDecoderMap.containsKey(contentTypeHeader)) {
            throw new IAE("Invalid Content-Type[%s]", new Object[]{contentTypeHeader});
        }
        this.contentTypeHeader = contentTypeHeader;
        if (acceptHeader != null && !this.encoderDecoderMap.containsKey(acceptHeader)) {
            throw new IAE("Invalid Accept[%s]", new Object[]{acceptHeader});
        }
        this.acceptHeader = acceptHeader;
    }

    public List<Map<String, Object>> query(String url, QueryType query) {
        try {
            String expectedResponseType = this.contentTypeHeader;
            Request request = new Request(HttpMethod.POST, new URL(url));
            request.setContent(this.contentTypeHeader, this.encoderDecoderMap.get(this.contentTypeHeader).encode(query));
            if (this.acceptHeader != null) {
                expectedResponseType = this.acceptHeader;
                request.addHeader("Accept", this.acceptHeader);
            }
            AtomicReference responseRef = new AtomicReference();
            ITRetryUtil.retryUntil(() -> {
                block2: {
                    try {
                        responseRef.set((BytesFullResponseHolder)this.httpClient.go(request, (HttpResponseHandler)new BytesFullResponseHandler()).get());
                    }
                    catch (Throwable t) {
                        ChannelException ce = (ChannelException)Throwables.getCauseOfType((Throwable)t, ChannelException.class);
                        if (ce == null) break block2;
                        LOG.info((Throwable)ce, "Encountered a channel exception. Retrying the query request", new Object[0]);
                        return false;
                    }
                }
                return true;
            }, true, 1000L, 3, "waiting for queries to complete");
            BytesFullResponseHolder response = (BytesFullResponseHolder)responseRef.get();
            if (!response.getStatus().equals((Object)HttpResponseStatus.OK)) {
                throw new ISE("Error while querying[%s] status[%s] content[%s]", new Object[]{url, response.getStatus(), new String(response.getContent(), StandardCharsets.UTF_8)});
            }
            String responseType = response.getResponse().headers().get("Content-Type");
            if (!expectedResponseType.equals(responseType)) {
                throw new ISE("Content-Type[%s] in HTTP response does not match the expected[%s]", new Object[]{responseType, expectedResponseType});
            }
            return this.encoderDecoderMap.get(responseType).decode(response.getContent());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Future<StatusResponseHolder> queryAsync(String url, QueryType query) {
        return this.queryAsync(url, query, null, null);
    }

    public Future<StatusResponseHolder> queryAsync(String url, QueryType query, String username, String password) {
        try {
            Request request = new Request(HttpMethod.POST, new URL(url));
            request.setContent("application/json", this.encoderDecoderMap.get("application/json").encode(query));
            request.setBasicAuthentication(username, password);
            return this.httpClient.go(request, (HttpResponseHandler)StatusResponseHandler.getInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public HttpResponseStatus cancelQuery(String url, long timeoutMs) {
        try {
            Request request = new Request(HttpMethod.DELETE, new URL(url));
            ListenableFuture future = this.httpClient.go(request, (HttpResponseHandler)StatusResponseHandler.getInstance());
            StatusResponseHolder responseHolder = (StatusResponseHolder)future.get(timeoutMs, TimeUnit.MILLISECONDS);
            return responseHolder.getStatus();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static class ObjectMapperEncoderDecoder
    implements EncoderDecoder {
        private final ObjectMapper om;

        ObjectMapperEncoderDecoder(ObjectMapper om) {
            this.om = om;
        }

        @Override
        public byte[] encode(Object content) throws IOException {
            return this.om.writeValueAsBytes(content);
        }

        @Override
        public List<Map<String, Object>> decode(byte[] content) throws IOException {
            return (List)this.om.readValue(content, (TypeReference)new TypeReference<List<Map<String, Object>>>(){});
        }
    }

    static interface EncoderDecoder {
        public byte[] encode(Object var1) throws IOException;

        public List<Map<String, Object>> decode(byte[] var1) throws IOException;
    }
}

