/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.testing.utils;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.testing.utils.EventSerializer;

public class JsonEventSerializer
implements EventSerializer {
    public static final String TYPE = "json";
    private final ObjectMapper jsonMapper;

    @JsonCreator
    public JsonEventSerializer(@JacksonInject @Json ObjectMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    @Override
    public byte[] serialize(List<Pair<String, Object>> event) throws JsonProcessingException {
        HashMap map = Maps.newHashMapWithExpectedSize((int)event.size());
        event.forEach(pair -> map.put((String)pair.lhs, pair.rhs));
        return this.jsonMapper.writeValueAsBytes((Object)map);
    }

    @Override
    public void close() {
    }
}

