/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.druid.query.aggregation.cardinality.types;

import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.dimension.ColumnSelectorStrategyFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;

public class CardinalityAggregatorColumnSelectorStrategyFactory
    implements ColumnSelectorStrategyFactory<CardinalityAggregatorColumnSelectorStrategy>
{
  @Override
  public CardinalityAggregatorColumnSelectorStrategy makeColumnSelectorStrategy(
      ColumnCapabilities capabilities, ColumnValueSelector selector
  )
  {
    ValueType type = capabilities.getType();
    switch (type) {
      case STRING:
        return new StringCardinalityAggregatorColumnSelectorStrategy();
      case LONG:
        return new LongCardinalityAggregatorColumnSelectorStrategy();
      case FLOAT:
        return new FloatCardinalityAggregatorColumnSelectorStrategy();
      case DOUBLE:
        return new DoubleCardinalityAggregatorColumnSelectorStrategy();
      default:
        throw new IAE("Cannot create query type helper from invalid type [%s]", type);
    }
  }
}
