/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.fasterxml.jackson.datatype.joda.deser.DurationDeserializer;
import com.fasterxml.jackson.datatype.joda.deser.PeriodDeserializer;
import java.io.IOException;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.Intervals;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;

class JodaStuff {
    JodaStuff() {
    }

    static SimpleModule register(SimpleModule module) {
        module.addKeyDeserializer(DateTime.class, (KeyDeserializer)new DateTimeKeyDeserializer());
        module.addDeserializer(DateTime.class, (JsonDeserializer)new DateTimeDeserializer());
        module.addSerializer(DateTime.class, (JsonSerializer)ToStringSerializer.instance);
        module.addDeserializer(Interval.class, (JsonDeserializer)new IntervalDeserializer());
        module.addSerializer(Interval.class, (JsonSerializer)ToStringSerializer.instance);
        PeriodDeserializer periodDeserializer = new PeriodDeserializer();
        module.addDeserializer(Period.class, (JsonDeserializer)periodDeserializer);
        module.addSerializer(Period.class, (JsonSerializer)ToStringSerializer.instance);
        module.addDeserializer(Duration.class, (JsonDeserializer)new DurationDeserializer());
        module.addSerializer(Duration.class, (JsonSerializer)ToStringSerializer.instance);
        return module;
    }

    private static class DateTimeDeserializer
    extends StdDeserializer<DateTime> {
        public DateTimeDeserializer() {
            super(DateTime.class);
        }

        public DateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonToken t = jp.getCurrentToken();
            if (t == JsonToken.VALUE_NUMBER_INT) {
                return DateTimes.utc((long)jp.getLongValue());
            }
            if (t == JsonToken.VALUE_STRING) {
                String str = jp.getText().trim();
                if (str.length() == 0) {
                    return null;
                }
                return DateTimes.ISO_DATE_OR_TIME_WITH_OFFSET.parse(str);
            }
            throw ctxt.mappingException(this.getValueClass());
        }
    }

    private static class DateTimeKeyDeserializer
    extends KeyDeserializer {
        private DateTimeKeyDeserializer() {
        }

        public Object deserializeKey(String key, DeserializationContext ctxt) {
            return DateTimes.of((String)key);
        }
    }

    private static class IntervalDeserializer
    extends StdDeserializer<Interval> {
        public IntervalDeserializer() {
            super(Interval.class);
        }

        public Interval deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
            return Intervals.of((String)jsonParser.getText());
        }
    }
}

