/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.BySegmentResultValueClass;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.Result;
import org.joda.time.DateTime;

public class BySegmentQueryRunner<T>
implements QueryRunner<T> {
    private final String segmentIdentifier;
    private final DateTime timestamp;
    private final QueryRunner<T> base;

    public BySegmentQueryRunner(String segmentIdentifier, DateTime timestamp, QueryRunner<T> base) {
        this.segmentIdentifier = segmentIdentifier;
        this.timestamp = timestamp;
        this.base = base;
    }

    @Override
    public Sequence<T> run(QueryPlus<T> queryPlus, Map<String, Object> responseContext) {
        if (QueryContexts.isBySegment(queryPlus.getQuery())) {
            Sequence<T> baseSequence = this.base.run(queryPlus, responseContext);
            List results = baseSequence.toList();
            return Sequences.simple(Collections.singletonList(new Result(this.timestamp, new BySegmentResultValueClass(results, this.segmentIdentifier, queryPlus.getQuery().getIntervals().get(0)))));
        }
        return this.base.run(queryPlus, responseContext);
    }
}

