/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.TableDataSource;

public class UnionDataSource
implements DataSource {
    @JsonProperty
    private final List<TableDataSource> dataSources;

    @JsonCreator
    public UnionDataSource(@JsonProperty(value="dataSources") List<TableDataSource> dataSources) {
        Preconditions.checkNotNull(dataSources, (Object)"dataSources cannot be null for unionDataSource");
        this.dataSources = dataSources;
    }

    @Override
    public List<String> getNames() {
        return Lists.transform(this.dataSources, (Function)new Function<TableDataSource, String>(){

            public String apply(TableDataSource input) {
                return (String)Iterables.getOnlyElement(input.getNames());
            }
        });
    }

    @JsonProperty
    public List<TableDataSource> getDataSources() {
        return this.dataSources;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnionDataSource that = (UnionDataSource)o;
        return this.dataSources.equals(that.dataSources);
    }

    public int hashCode() {
        return this.dataSources.hashCode();
    }

    public String toString() {
        return "UnionDataSource{dataSources=" + this.dataSources + '}';
    }
}

