/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.last;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.nio.ByteBuffer;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.SerializablePairLongString;
import org.apache.druid.query.aggregation.last.StringLastAggregator;
import org.apache.druid.query.aggregation.last.StringLastAggregatorFactory;
import org.apache.druid.query.aggregation.last.StringLastBufferAggregator;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnSelectorFactory;

@JsonTypeName(value="stringLastFold")
public class StringLastFoldingAggregatorFactory
extends StringLastAggregatorFactory {
    public StringLastFoldingAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="maxStringBytes") Integer maxStringBytes) {
        super(name, fieldName, maxStringBytes);
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory, final BaseObjectColumnValueSelector selector) {
        return new StringLastAggregator(null, null, this.maxStringBytes){

            @Override
            public void aggregate() {
                SerializablePairLongString pair = (SerializablePairLongString)((Object)selector.getObject());
                if (pair != null && (Long)pair.lhs >= this.lastTime) {
                    this.lastTime = (Long)pair.lhs;
                    this.lastValue = (String)pair.rhs;
                }
            }
        };
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory, final BaseObjectColumnValueSelector selector) {
        return new StringLastBufferAggregator(null, null, this.maxStringBytes){

            @Override
            public void aggregate(ByteBuffer buf, int position) {
                SerializablePairLongString pair = (SerializablePairLongString)((Object)selector.getObject());
                if (pair != null && pair.lhs != null) {
                    ByteBuffer mutationBuffer = buf.duplicate();
                    mutationBuffer.position(position);
                    long lastTime = mutationBuffer.getLong(position);
                    if ((Long)pair.lhs >= lastTime) {
                        mutationBuffer.putLong(position, (Long)pair.lhs);
                        if (pair.rhs != null) {
                            byte[] valueBytes = StringUtils.toUtf8((String)((String)pair.rhs));
                            mutationBuffer.putInt(position + 8, valueBytes.length);
                            mutationBuffer.position(position + 8 + 4);
                            mutationBuffer.put(valueBytes);
                        } else {
                            mutationBuffer.putInt(position + 8, 0);
                        }
                    }
                }
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }
}

