/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.extraction;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.extraction.ExtractionFn;

public class BucketExtractionFn
implements ExtractionFn {
    private final double size;
    private final double offset;

    @JsonCreator
    public BucketExtractionFn(@Nullable @JsonProperty(value="size") Double size, @Nullable @JsonProperty(value="offset") Double offset) {
        this.size = size == null ? 1.0 : size;
        this.offset = offset == null ? 0.0 : offset;
    }

    @JsonProperty
    public double getSize() {
        return this.size;
    }

    @JsonProperty
    public double getOffset() {
        return this.offset;
    }

    @Override
    @Nullable
    public String apply(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            return this.bucket(((Number)value).doubleValue());
        }
        if (value instanceof String) {
            return this.apply((String)value);
        }
        return null;
    }

    @Override
    @Nullable
    public String apply(@Nullable String value) {
        if (value == null) {
            return null;
        }
        try {
            return this.bucket(Double.parseDouble(value));
        }
        catch (NullPointerException | NumberFormatException ex) {
            return null;
        }
    }

    @Override
    public String apply(long value) {
        return this.bucket(value);
    }

    private String bucket(double value) {
        double ret = Math.floor((value - this.offset) / this.size) * this.size + this.offset;
        return ret == (double)((long)ret) ? String.valueOf((long)ret) : String.valueOf(ret);
    }

    @Override
    public boolean preservesOrdering() {
        return false;
    }

    @Override
    public ExtractionFn.ExtractionType getExtractionType() {
        return ExtractionFn.ExtractionType.MANY_TO_ONE;
    }

    public byte[] getCacheKey() {
        return ByteBuffer.allocate(17).put((byte)13).putDouble(this.size).putDouble(this.offset).array();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BucketExtractionFn that = (BucketExtractionFn)o;
        if (Double.compare(that.size, this.size) != 0) {
            return false;
        }
        return Double.compare(that.offset, this.offset) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.size);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.offset);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return StringUtils.format((String)"bucket(%f, %f)", (Object[])new Object[]{this.size, this.offset});
    }
}

