/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueGetter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.ValueMatcherColumnSelectorStrategy;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;

public class DoubleValueMatcherColumnSelectorStrategy
implements ValueMatcherColumnSelectorStrategy<BaseDoubleColumnValueSelector> {
    @Override
    public ValueMatcher makeValueMatcher(final BaseDoubleColumnValueSelector selector, String value) {
        Double matchVal = DimensionHandlerUtils.convertObjectToDouble(value);
        if (matchVal == null) {
            return ValueMatcher.nullValueMatcher(selector);
        }
        final long matchValLongBits = Double.doubleToLongBits(matchVal);
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return Double.doubleToLongBits(selector.getDouble()) == matchValLongBits;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    @Override
    public ValueMatcher makeValueMatcher(final BaseDoubleColumnValueSelector selector, DruidPredicateFactory predicateFactory) {
        final DruidDoublePredicate predicate = predicateFactory.makeDoublePredicate();
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                if (selector.isNull()) {
                    return predicate.applyNull();
                }
                return predicate.applyDouble(selector.getDouble());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    @Override
    public ValueGetter makeValueGetter(BaseDoubleColumnValueSelector selector) {
        return () -> {
            if (selector.isNull()) {
                return null;
            }
            return new String[]{Double.toString(selector.getDouble())};
        };
    }
}

