/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.ValueGetter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.ValueMatcherColumnSelectorStrategy;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.DimensionHandlerUtils;

public class FloatValueMatcherColumnSelectorStrategy
implements ValueMatcherColumnSelectorStrategy<BaseFloatColumnValueSelector> {
    @Override
    public ValueMatcher makeValueMatcher(final BaseFloatColumnValueSelector selector, String value) {
        Float matchVal = DimensionHandlerUtils.convertObjectToFloat(value);
        if (matchVal == null) {
            return ValueMatcher.nullValueMatcher(selector);
        }
        final int matchValIntBits = Float.floatToIntBits(matchVal.floatValue());
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                return Float.floatToIntBits(selector.getFloat()) == matchValIntBits;
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
            }
        };
    }

    @Override
    public ValueMatcher makeValueMatcher(final BaseFloatColumnValueSelector selector, DruidPredicateFactory predicateFactory) {
        final DruidFloatPredicate predicate = predicateFactory.makeFloatPredicate();
        return new ValueMatcher(){

            @Override
            public boolean matches() {
                if (selector.isNull()) {
                    return predicate.applyNull();
                }
                return predicate.applyFloat(selector.getFloat());
            }

            @Override
            public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                inspector.visit("selector", selector);
                inspector.visit("predicate", predicate);
            }
        };
    }

    @Override
    public ValueGetter makeValueGetter(BaseFloatColumnValueSelector selector) {
        return () -> {
            if (selector.isNull()) {
                return null;
            }
            return new String[]{Float.toString(selector.getFloat())};
        };
    }
}

