/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.filter;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeRangeSet;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Floats;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.common.guava.GuavaUtils;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.DruidDoublePredicate;
import org.apache.druid.query.filter.DruidFloatPredicate;
import org.apache.druid.query.filter.DruidLongPredicate;
import org.apache.druid.query.filter.DruidPredicateFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.InDimFilter;
import org.apache.druid.segment.filter.DimensionPredicateFilter;
import org.apache.druid.segment.filter.SelectorFilter;

public class SelectorDimFilter
implements DimFilter {
    private final String dimension;
    @Nullable
    private final String value;
    private final ExtractionFn extractionFn;
    private final Object initLock = new Object();
    private DruidLongPredicate longPredicate;
    private DruidFloatPredicate floatPredicate;
    private DruidDoublePredicate druidDoublePredicate;

    @JsonCreator
    public SelectorDimFilter(@JsonProperty(value="dimension") String dimension, @JsonProperty(value="value") String value, @JsonProperty(value="extractionFn") ExtractionFn extractionFn) {
        Preconditions.checkArgument((dimension != null ? 1 : 0) != 0, (Object)"dimension must not be null");
        this.dimension = dimension;
        this.value = NullHandling.emptyToNullIfNeeded((String)value);
        this.extractionFn = extractionFn;
    }

    public byte[] getCacheKey() {
        return new CacheKeyBuilder(0).appendByte((byte)-1).appendString(this.dimension).appendByte((byte)-1).appendByte(this.value == null ? (byte)1 : 0).appendString(this.value).appendByte((byte)-1).appendByteArray(this.extractionFn == null ? new byte[]{} : this.extractionFn.getCacheKey()).build();
    }

    @Override
    public DimFilter optimize() {
        return new InDimFilter(this.dimension, Collections.singletonList(this.value), this.extractionFn).optimize();
    }

    @Override
    public Filter toFilter() {
        if (this.extractionFn == null) {
            return new SelectorFilter(this.dimension, this.value);
        }
        DruidPredicateFactory predicateFactory = new DruidPredicateFactory(){

            @Override
            public Predicate<String> makeStringPredicate() {
                return Predicates.equalTo((Object)SelectorDimFilter.this.value);
            }

            @Override
            public DruidLongPredicate makeLongPredicate() {
                SelectorDimFilter.this.initLongPredicate();
                return SelectorDimFilter.this.longPredicate;
            }

            @Override
            public DruidFloatPredicate makeFloatPredicate() {
                SelectorDimFilter.this.initFloatPredicate();
                return SelectorDimFilter.this.floatPredicate;
            }

            @Override
            public DruidDoublePredicate makeDoublePredicate() {
                SelectorDimFilter.this.initDoublePredicate();
                return SelectorDimFilter.this.druidDoublePredicate;
            }
        };
        return new DimensionPredicateFilter(this.dimension, predicateFactory, this.extractionFn);
    }

    @JsonProperty
    public String getDimension() {
        return this.dimension;
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @JsonProperty
    public ExtractionFn getExtractionFn() {
        return this.extractionFn;
    }

    public String toString() {
        if (this.extractionFn != null) {
            return StringUtils.format((String)"%s(%s) = %s", (Object[])new Object[]{this.extractionFn, this.dimension, this.value});
        }
        return StringUtils.format((String)"%s = %s", (Object[])new Object[]{this.dimension, this.value});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectorDimFilter that = (SelectorDimFilter)o;
        if (!this.dimension.equals(that.dimension)) {
            return false;
        }
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return this.extractionFn != null ? this.extractionFn.equals(that.extractionFn) : that.extractionFn == null;
    }

    @Override
    public RangeSet<String> getDimensionRangeSet(String dimension) {
        if (!Objects.equals(this.getDimension(), dimension) || this.getExtractionFn() != null) {
            return null;
        }
        TreeRangeSet retSet = TreeRangeSet.create();
        String valueEquivalent = NullHandling.nullToEmptyIfNeeded((String)this.value);
        if (valueEquivalent == null) {
            retSet.add(Range.lessThan((Comparable)((Object)"")));
        } else {
            retSet.add(Range.singleton((Comparable)((Object)valueEquivalent)));
        }
        return retSet;
    }

    @Override
    public HashSet<String> getRequiredColumns() {
        return Sets.newHashSet((Object[])new String[]{this.dimension});
    }

    public int hashCode() {
        int result = this.dimension.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + (this.extractionFn != null ? this.extractionFn.hashCode() : 0);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLongPredicate() {
        if (this.longPredicate != null) {
            return;
        }
        Object object = this.initLock;
        synchronized (object) {
            if (this.longPredicate != null) {
                return;
            }
            if (this.value == null) {
                this.longPredicate = DruidLongPredicate.MATCH_NULL_ONLY;
                return;
            }
            Long valueAsLong = GuavaUtils.tryParseLong((String)this.value);
            if (valueAsLong == null) {
                this.longPredicate = DruidLongPredicate.ALWAYS_FALSE;
            } else {
                long unboxedLong = valueAsLong;
                this.longPredicate = input -> input == unboxedLong;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFloatPredicate() {
        if (this.floatPredicate != null) {
            return;
        }
        Object object = this.initLock;
        synchronized (object) {
            if (this.floatPredicate != null) {
                return;
            }
            if (this.value == null) {
                this.floatPredicate = DruidFloatPredicate.MATCH_NULL_ONLY;
                return;
            }
            Float valueAsFloat = Floats.tryParse((String)this.value);
            if (valueAsFloat == null) {
                this.floatPredicate = DruidFloatPredicate.ALWAYS_FALSE;
            } else {
                int floatBits = Float.floatToIntBits(valueAsFloat.floatValue());
                this.floatPredicate = input -> Float.floatToIntBits(input) == floatBits;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initDoublePredicate() {
        if (this.druidDoublePredicate != null) {
            return;
        }
        Object object = this.initLock;
        synchronized (object) {
            if (this.druidDoublePredicate != null) {
                return;
            }
            if (this.value == null) {
                this.druidDoublePredicate = DruidDoublePredicate.MATCH_NULL_ONLY;
                return;
            }
            Double aDouble = Doubles.tryParse((String)this.value);
            if (aDouble == null) {
                this.druidDoublePredicate = DruidDoublePredicate.ALWAYS_FALSE;
            } else {
                long bits = Double.doubleToLongBits(aDouble);
                this.druidDoublePredicate = input -> Double.doubleToLongBits(input) == bits;
            }
        }
    }
}

