/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.data.input.MapBasedRow;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.Cacheable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.guava.MappedSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.query.CacheStrategy;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.IntervalChunkingQueryRunnerDecorator;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.SubqueryQueryRunner;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.MetricManipulationFn;
import org.apache.druid.query.aggregation.MetricManipulatorFns;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.groupby.DefaultGroupByQueryMetricsFactory;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryMetrics;
import org.apache.druid.query.groupby.GroupByQueryMetricsFactory;
import org.apache.druid.query.groupby.resource.GroupByQueryResource;
import org.apache.druid.query.groupby.strategy.GroupByStrategy;
import org.apache.druid.query.groupby.strategy.GroupByStrategySelector;
import org.apache.druid.segment.DimensionHandlerUtils;
import org.joda.time.DateTime;

public class GroupByQueryQueryToolChest
extends QueryToolChest<Row, GroupByQuery> {
    private static final byte GROUPBY_QUERY = 20;
    private static final TypeReference<Object> OBJECT_TYPE_REFERENCE = new TypeReference<Object>(){};
    private static final TypeReference<Row> TYPE_REFERENCE = new TypeReference<Row>(){};
    public static final String GROUP_BY_MERGE_KEY = "groupByMerge";
    private final GroupByStrategySelector strategySelector;
    private final IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator;
    private final GroupByQueryMetricsFactory queryMetricsFactory;

    @VisibleForTesting
    public GroupByQueryQueryToolChest(GroupByStrategySelector strategySelector, IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator) {
        this(strategySelector, intervalChunkingQueryRunnerDecorator, DefaultGroupByQueryMetricsFactory.instance());
    }

    @Inject
    public GroupByQueryQueryToolChest(GroupByStrategySelector strategySelector, IntervalChunkingQueryRunnerDecorator intervalChunkingQueryRunnerDecorator, GroupByQueryMetricsFactory queryMetricsFactory) {
        this.strategySelector = strategySelector;
        this.intervalChunkingQueryRunnerDecorator = intervalChunkingQueryRunnerDecorator;
        this.queryMetricsFactory = queryMetricsFactory;
    }

    @Override
    public QueryRunner<Row> mergeResults(final QueryRunner<Row> runner) {
        return new QueryRunner<Row>(){

            @Override
            public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
                if (QueryContexts.isBySegment(queryPlus.getQuery())) {
                    return runner.run(queryPlus, responseContext);
                }
                GroupByQuery groupByQuery = (GroupByQuery)queryPlus.getQuery();
                if (GroupByQueryQueryToolChest.this.strategySelector.strategize(groupByQuery).doMergeResults(groupByQuery)) {
                    return GroupByQueryQueryToolChest.this.initAndMergeGroupByResults(groupByQuery, runner, responseContext);
                }
                return runner.run(queryPlus, responseContext);
            }
        };
    }

    private Sequence<Row> initAndMergeGroupByResults(GroupByQuery query, QueryRunner<Row> runner, Map<String, Object> context) {
        GroupByStrategy groupByStrategy = this.strategySelector.strategize(query);
        GroupByQueryResource resource = groupByStrategy.prepareResource(query, false);
        return Sequences.withBaggage(this.mergeGroupByResults(groupByStrategy, query, resource, runner, context), (Closeable)resource);
    }

    private Sequence<Row> mergeGroupByResults(GroupByStrategy groupByStrategy, GroupByQuery query, GroupByQueryResource resource, QueryRunner<Row> runner, Map<String, Object> context) {
        DataSource dataSource = query.getDataSource();
        if (dataSource instanceof QueryDataSource) {
            GroupByQuery subquery;
            try {
                TreeMap subqueryContext = Maps.newTreeMap();
                if (query.getContext() != null) {
                    for (Map.Entry<String, Object> entry : query.getContext().entrySet()) {
                        if (entry.getValue() == null) continue;
                        subqueryContext.put(entry.getKey(), entry.getValue());
                    }
                }
                if (((QueryDataSource)dataSource).getQuery().getContext() != null) {
                    subqueryContext.putAll(((QueryDataSource)dataSource).getQuery().getContext());
                }
                subqueryContext.put("sortByDimsFirst", false);
                subquery = (GroupByQuery)((QueryDataSource)dataSource).getQuery().withOverriddenContext(subqueryContext);
            }
            catch (ClassCastException e) {
                throw new UnsupportedOperationException("Subqueries must be of type 'group by'");
            }
            MappedSequence subqueryResult = this.mergeGroupByResults(groupByStrategy, (GroupByQuery)subquery.withOverriddenContext((Map)ImmutableMap.of((Object)"sortResults", (Object)false)), resource, runner, context);
            MappedSequence finalizingResults = QueryContexts.isFinalize(subquery, false) ? new MappedSequence(subqueryResult, arg_0 -> this.makePreComputeManipulatorFn(subquery, MetricManipulatorFns.finalizing()).apply(arg_0)) : subqueryResult;
            if (query.getSubtotalsSpec() != null) {
                return groupByStrategy.processSubtotalsSpec(query, resource, groupByStrategy.processSubqueryResult(subquery, query, resource, (Sequence<Row>)finalizingResults));
            }
            return groupByStrategy.applyPostProcessing(groupByStrategy.processSubqueryResult(subquery, query, resource, (Sequence<Row>)finalizingResults), query);
        }
        if (query.getSubtotalsSpec() != null) {
            return groupByStrategy.processSubtotalsSpec(query, resource, groupByStrategy.mergeResults(runner, query.withSubtotalsSpec(null), context));
        }
        return groupByStrategy.applyPostProcessing(groupByStrategy.mergeResults(runner, query, context), query);
    }

    public GroupByQueryMetrics makeMetrics(GroupByQuery query) {
        GroupByQueryMetrics queryMetrics = this.queryMetricsFactory.makeMetrics();
        queryMetrics.query(query);
        return queryMetrics;
    }

    @Override
    public Function<Row, Row> makePreComputeManipulatorFn(final GroupByQuery query, final MetricManipulationFn fn) {
        if (MetricManipulatorFns.identity().equals(fn)) {
            return Functions.identity();
        }
        return new Function<Row, Row>(){

            public Row apply(Row input) {
                if (input instanceof MapBasedRow) {
                    MapBasedRow inputRow = (MapBasedRow)input;
                    HashMap values = Maps.newHashMap((Map)inputRow.getEvent());
                    for (AggregatorFactory agg : query.getAggregatorSpecs()) {
                        values.put(agg.getName(), fn.manipulate(agg, inputRow.getEvent().get(agg.getName())));
                    }
                    return new MapBasedRow(inputRow.getTimestamp(), (Map)values);
                }
                return input;
            }
        };
    }

    @Override
    public Function<Row, Row> makePostComputeManipulatorFn(GroupByQuery query, MetricManipulationFn fn) {
        ImmutableSet optimizedDims = ImmutableSet.copyOf((Iterable)Iterables.transform(GroupByQueryQueryToolChest.extractionsToRewrite(query), (Function)new Function<DimensionSpec, String>(){

            public String apply(DimensionSpec input) {
                return input.getOutputName();
            }
        }));
        final Function<Row, Row> preCompute = this.makePreComputeManipulatorFn(query, fn);
        if (optimizedDims.isEmpty()) {
            return preCompute;
        }
        HashMap<String, ExtractionFn> extractionFnMap = new HashMap<String, ExtractionFn>();
        for (DimensionSpec dimensionSpec : query.getDimensions()) {
            String dimension = dimensionSpec.getOutputName();
            if (!optimizedDims.contains(dimension)) continue;
            extractionFnMap.put(dimension, dimensionSpec.getExtractionFn());
        }
        return new Function<Row, Row>((Set)optimizedDims, extractionFnMap){
            final /* synthetic */ Set val$optimizedDims;
            final /* synthetic */ Map val$extractionFnMap;
            {
                this.val$optimizedDims = set;
                this.val$extractionFnMap = map;
            }

            @Nullable
            public Row apply(Row input) {
                Row preRow = (Row)preCompute.apply((Object)input);
                if (preRow instanceof MapBasedRow) {
                    MapBasedRow preMapRow = (MapBasedRow)preRow;
                    HashMap event = Maps.newHashMap((Map)preMapRow.getEvent());
                    for (String dim : this.val$optimizedDims) {
                        Object eventVal = event.get(dim);
                        event.put(dim, ((ExtractionFn)this.val$extractionFnMap.get(dim)).apply(eventVal));
                    }
                    return new MapBasedRow(preMapRow.getTimestamp(), (Map)event);
                }
                return preRow;
            }
        };
    }

    @Override
    public TypeReference<Row> getResultTypeReference() {
        return TYPE_REFERENCE;
    }

    @Override
    public QueryRunner<Row> preMergeQueryDecoration(final QueryRunner<Row> runner) {
        return new SubqueryQueryRunner<Row>(new QueryRunner<Row>(){

            @Override
            public Sequence<Row> run(QueryPlus<Row> queryPlus, Map<String, Object> responseContext) {
                GroupByQuery groupByQuery = (GroupByQuery)queryPlus.getQuery();
                if (groupByQuery.getDimFilter() != null) {
                    groupByQuery = groupByQuery.withDimFilter(groupByQuery.getDimFilter().optimize());
                }
                GroupByQuery delegateGroupByQuery = groupByQuery;
                ArrayList<DimensionSpec> dimensionSpecs = new ArrayList<DimensionSpec>();
                ImmutableSet optimizedDimensions = ImmutableSet.copyOf((Iterable)Iterables.transform(GroupByQueryQueryToolChest.extractionsToRewrite(delegateGroupByQuery), (Function)new Function<DimensionSpec, String>(){

                    public String apply(DimensionSpec input) {
                        return input.getDimension();
                    }
                }));
                for (DimensionSpec dimensionSpec : delegateGroupByQuery.getDimensions()) {
                    if (optimizedDimensions.contains(dimensionSpec.getDimension())) {
                        dimensionSpecs.add(new DefaultDimensionSpec(dimensionSpec.getDimension(), dimensionSpec.getOutputName()));
                        continue;
                    }
                    dimensionSpecs.add(dimensionSpec);
                }
                return GroupByQueryQueryToolChest.this.strategySelector.strategize(delegateGroupByQuery).createIntervalChunkingRunner(GroupByQueryQueryToolChest.this.intervalChunkingQueryRunnerDecorator, runner, GroupByQueryQueryToolChest.this).run(queryPlus.withQuery(delegateGroupByQuery.withDimensionSpecs(dimensionSpecs)), responseContext);
            }
        });
    }

    @Override
    public CacheStrategy<Row, Object, GroupByQuery> getCacheStrategy(final GroupByQuery query) {
        return new CacheStrategy<Row, Object, GroupByQuery>(){
            private static final byte CACHE_STRATEGY_VERSION = 1;
            private final List<AggregatorFactory> aggs;
            private final List<DimensionSpec> dims;
            {
                this.aggs = query.getAggregatorSpecs();
                this.dims = query.getDimensions();
            }

            @Override
            public boolean isCacheable(GroupByQuery query2, boolean willMergeRunners) {
                return GroupByQueryQueryToolChest.this.strategySelector.strategize(query2).isCacheable(willMergeRunners);
            }

            @Override
            public byte[] computeCacheKey(GroupByQuery query2) {
                return new CacheKeyBuilder(20).appendByte((byte)1).appendCacheable((Cacheable)query2.getGranularity()).appendCacheable(query2.getDimFilter()).appendCacheables(query2.getAggregatorSpecs()).appendCacheables(query2.getDimensions()).appendCacheable(query2.getVirtualColumns()).build();
            }

            @Override
            public TypeReference<Object> getCacheObjectClazz() {
                return OBJECT_TYPE_REFERENCE;
            }

            @Override
            public Function<Row, Object> prepareForCache(final boolean isResultLevelCache) {
                return new Function<Row, Object>(){

                    public Object apply(Row input) {
                        if (input instanceof MapBasedRow) {
                            MapBasedRow row = (MapBasedRow)input;
                            ArrayList retVal = Lists.newArrayListWithCapacity((int)(1 + dims.size() + aggs.size()));
                            retVal.add(row.getTimestamp().getMillis());
                            Map event = row.getEvent();
                            for (DimensionSpec dim : dims) {
                                retVal.add(event.get(dim.getOutputName()));
                            }
                            for (AggregatorFactory agg : aggs) {
                                retVal.add(event.get(agg.getName()));
                            }
                            if (isResultLevelCache) {
                                for (PostAggregator postAgg : query.getPostAggregatorSpecs()) {
                                    retVal.add(event.get(postAgg.getName()));
                                }
                            }
                            return retVal;
                        }
                        throw new ISE("Don't know how to cache input rows of type[%s]", new Object[]{input.getClass()});
                    }
                };
            }

            @Override
            public Function<Object, Row> pullFromCache(final boolean isResultLevelCache) {
                return new Function<Object, Row>(){
                    private final Granularity granularity;
                    {
                        this.granularity = query.getGranularity();
                    }

                    public Row apply(Object input) {
                        Iterator results = ((List)input).iterator();
                        DateTime timestamp = this.granularity.toDateTime(((Number)results.next()).longValue());
                        LinkedHashMap event = Maps.newLinkedHashMap();
                        Iterator dimsIter = dims.iterator();
                        while (dimsIter.hasNext() && results.hasNext()) {
                            DimensionSpec dimensionSpec = (DimensionSpec)dimsIter.next();
                            event.put(dimensionSpec.getOutputName(), DimensionHandlerUtils.convertObjectToType(results.next(), dimensionSpec.getOutputType()));
                        }
                        Iterator aggsIter = aggs.iterator();
                        while (aggsIter.hasNext() && results.hasNext()) {
                            AggregatorFactory factory = (AggregatorFactory)aggsIter.next();
                            event.put(factory.getName(), factory.deserialize(results.next()));
                        }
                        if (isResultLevelCache) {
                            Iterator<PostAggregator> postItr = query.getPostAggregatorSpecs().iterator();
                            while (postItr.hasNext() && results.hasNext()) {
                                event.put(postItr.next().getName(), results.next());
                            }
                        }
                        if (dimsIter.hasNext() || aggsIter.hasNext() || results.hasNext()) {
                            throw new ISE("Found left over objects while reading from cache!! dimsIter[%s] aggsIter[%s] results[%s]", new Object[]{dimsIter.hasNext(), aggsIter.hasNext(), results.hasNext()});
                        }
                        return new MapBasedRow(timestamp, (Map)event);
                    }
                };
            }
        };
    }

    public static Collection<DimensionSpec> extractionsToRewrite(GroupByQuery query) {
        return Collections2.filter(query.getDimensions(), (Predicate)new Predicate<DimensionSpec>(){

            public boolean apply(DimensionSpec input) {
                return input.getExtractionFn() != null && ExtractionFn.ExtractionType.ONE_TO_ONE.equals((Object)input.getExtractionFn().getExtractionType());
            }
        });
    }
}

