/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import java.io.Closeable;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.common.guava.SettableSupplier;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.Accumulator;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.FilteredSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.Query;
import org.apache.druid.query.ResourceLimitExceededException;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.groupby.GroupByQuery;
import org.apache.druid.query.groupby.GroupByQueryConfig;
import org.apache.druid.query.groupby.RowBasedColumnSelectorFactory;
import org.apache.druid.query.groupby.epinephelinae.AggregateResult;
import org.apache.druid.query.groupby.epinephelinae.CloseableGrouperIterator;
import org.apache.druid.query.groupby.epinephelinae.Grouper;
import org.apache.druid.query.groupby.epinephelinae.LimitedTemporaryStorage;
import org.apache.druid.query.groupby.epinephelinae.RowBasedGrouperHelper;
import org.apache.druid.query.groupby.resource.GroupByQueryResource;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.filter.BooleanValueMatcher;
import org.apache.druid.segment.filter.Filters;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class GroupByRowProcessor {
    public static Grouper createGrouper(Query queryParam, Sequence<Row> rows, Map<String, ValueType> rowSignature, GroupByQueryConfig config, final GroupByQueryResource resource, ObjectMapper spillMapper, String processingTmpDir, int mergeBufferSize, final List<Closeable> closeOnExit) {
        GroupByQuery query = (GroupByQuery)queryParam;
        GroupByQueryConfig querySpecificConfig = config.withOverrides(query);
        AggregatorFactory[] aggregatorFactories = new AggregatorFactory[query.getAggregatorSpecs().size()];
        for (int i = 0; i < query.getAggregatorSpecs().size(); ++i) {
            aggregatorFactories[i] = query.getAggregatorSpecs().get(i);
        }
        File temporaryStorageDirectory = new File(processingTmpDir, StringUtils.format((String)"druid-groupBy-%s_%s", (Object[])new Object[]{UUID.randomUUID(), query.getId()}));
        final List<Interval> queryIntervals = query.getIntervals();
        Filter filter = Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getDimFilter()));
        final SettableSupplier rowSupplier = new SettableSupplier();
        RowBasedColumnSelectorFactory columnSelectorFactory = RowBasedColumnSelectorFactory.create((Supplier<? extends Row>)rowSupplier, rowSignature);
        final ValueMatcher filterMatcher = filter == null ? BooleanValueMatcher.of(true) : filter.makeMatcher(columnSelectorFactory);
        FilteredSequence filteredSequence = new FilteredSequence(rows, (Predicate)new Predicate<Row>(){

            public boolean apply(Row input) {
                boolean inInterval = false;
                DateTime rowTime = input.getTimestamp();
                for (Interval queryInterval : queryIntervals) {
                    if (!queryInterval.contains((ReadableInstant)rowTime)) continue;
                    inInterval = true;
                    break;
                }
                if (!inInterval) {
                    return false;
                }
                rowSupplier.set((Object)input);
                return filterMatcher.matches();
            }
        });
        LimitedTemporaryStorage temporaryStorage = new LimitedTemporaryStorage(temporaryStorageDirectory, querySpecificConfig.getMaxOnDiskStorage());
        closeOnExit.add(temporaryStorage);
        Pair<Grouper<RowBasedGrouperHelper.RowBasedKey>, Accumulator<AggregateResult, Row>> pair = RowBasedGrouperHelper.createGrouperAccumulatorPair(query, true, rowSignature, querySpecificConfig, new Supplier<ByteBuffer>(){

            public ByteBuffer get() {
                ResourceHolder<ByteBuffer> mergeBufferHolder = resource.getMergeBuffer();
                closeOnExit.add(mergeBufferHolder);
                return (ByteBuffer)mergeBufferHolder.get();
            }
        }, temporaryStorage, spillMapper, aggregatorFactories, mergeBufferSize);
        Grouper grouper = (Grouper)pair.lhs;
        Accumulator accumulator = (Accumulator)pair.rhs;
        closeOnExit.add(grouper);
        AggregateResult retVal = (AggregateResult)filteredSequence.accumulate((Object)AggregateResult.ok(), accumulator);
        if (!retVal.isOk()) {
            throw new ResourceLimitExceededException(retVal.getReason(), new Object[0]);
        }
        return grouper;
    }

    public static Sequence<Row> getRowsFromGrouper(final GroupByQuery query, final List<String> subtotalSpec, final Supplier<Grouper> grouper) {
        return new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Row, CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row>>(){

            public CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row> make() {
                return RowBasedGrouperHelper.makeGrouperIterator((Grouper)grouper.get(), query, subtotalSpec, () -> {});
            }

            public void cleanup(CloseableGrouperIterator<RowBasedGrouperHelper.RowBasedKey, Row> iterFromMake) {
                iterFromMake.close();
            }
        });
    }
}

