/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.having;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.apache.druid.data.input.Row;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.groupby.having.BaseHavingSpec;
import org.apache.druid.query.groupby.having.HavingSpec;
import org.apache.druid.segment.column.ValueType;

public class AndHavingSpec
extends BaseHavingSpec {
    private final List<HavingSpec> havingSpecs;

    @JsonCreator
    public AndHavingSpec(@JsonProperty(value="havingSpecs") List<HavingSpec> havingSpecs) {
        this.havingSpecs = havingSpecs == null ? ImmutableList.of() : havingSpecs;
    }

    @JsonProperty(value="havingSpecs")
    public List<HavingSpec> getHavingSpecs() {
        return this.havingSpecs;
    }

    @Override
    public void setRowSignature(Map<String, ValueType> rowSignature) {
        for (HavingSpec havingSpec : this.havingSpecs) {
            havingSpec.setRowSignature(rowSignature);
        }
    }

    @Override
    public void setAggregators(Map<String, AggregatorFactory> aggregators) {
        for (HavingSpec havingSpec : this.havingSpecs) {
            havingSpec.setAggregators(aggregators);
        }
    }

    @Override
    public boolean eval(Row row) {
        for (HavingSpec havingSpec : this.havingSpecs) {
            if (havingSpec.eval(row)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndHavingSpec that = (AndHavingSpec)o;
        return !(this.havingSpecs != null ? !this.havingSpecs.equals(that.havingSpecs) : that.havingSpecs != null);
    }

    public int hashCode() {
        return this.havingSpecs != null ? this.havingSpecs.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AndHavingSpec");
        sb.append("{havingSpecs=").append(this.havingSpecs);
        sb.append('}');
        return sb.toString();
    }
}

