/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.ordering;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Comparator;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.ordering.StringComparators;

public abstract class StringComparator
implements Comparator<String> {
    @JsonCreator
    public static StringComparator fromString(String type) {
        switch (StringUtils.toLowerCase((String)type)) {
            case "lexicographic": {
                return StringComparators.LEXICOGRAPHIC;
            }
            case "alphanumeric": {
                return StringComparators.ALPHANUMERIC;
            }
            case "strlen": {
                return StringComparators.STRLEN;
            }
            case "numeric": {
                return StringComparators.NUMERIC;
            }
        }
        throw new IAE("Unknown string comparator[%s]", new Object[]{type});
    }

    public abstract byte[] getCacheKey();
}

